package com.help.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.help.annotation.*;
import com.help.common.validate.*;
import com.help.constraint.IHelpDomain;
import java.util.Date;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 操作日志
 * 对应数据库表 p_operation_log
 *
 * @author: Help-Generator Template By YuBin
 * @Date: 2019/9/29 14:33
 */
public class POperationLog implements IHelpDomain {
    @Name("操作编号")
    @SequenceGenerator("SEQ_p_operation_log")
    private Long id;

    @Name("操作用户")
    @Length(max=20,dbmode=false)
    @Required
    private String userNo;

    @Name("操作内容")
    @Length(max=200,dbmode=false)
    @Required
    private String content;

    @Name("操作类型")
    @Length(max=10,dbmode=false)
    @Required
    private String opType;

    @Name("操作人IP")
    @Length(max=20,dbmode=false)
    private String ipAddr;

    @Name("操作是否成功")
    @Length(max=10,dbmode=false)
    private String success;

    @Name("操作URL")
    @Length(max=200,dbmode=false)
    private String url;

    @Name("操作时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Required
    private Date gmtCreate;

    public Long getId() {
        return id;
    }

    public POperationLog withId(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUserNo() {
        return userNo;
    }

    public POperationLog withUserNo(String userNo) {
        this.setUserNo(userNo);
        return this;
    }

    public void setUserNo(String userNo) {
        this.userNo = userNo == null ? null : userNo.trim();
    }

    public String getContent() {
        return content;
    }

    public POperationLog withContent(String content) {
        this.setContent(content);
        return this;
    }

    public void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

    public String getOpType() {
        return opType;
    }

    public POperationLog withOpType(String opType) {
        this.setOpType(opType);
        return this;
    }

    public void setOpType(String opType) {
        this.opType = opType == null ? null : opType.trim();
    }

    public String getIpAddr() {
        return ipAddr;
    }

    public POperationLog withIpAddr(String ipAddr) {
        this.setIpAddr(ipAddr);
        return this;
    }

    public void setIpAddr(String ipAddr) {
        this.ipAddr = ipAddr == null ? null : ipAddr.trim();
    }

    public String getSuccess() {
        return success;
    }

    public POperationLog withSuccess(String success) {
        this.setSuccess(success);
        return this;
    }

    public void setSuccess(String success) {
        this.success = success == null ? null : success.trim();
    }

    public String getUrl() {
        return url;
    }

    public POperationLog withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public void setUrl(String url) {
        this.url = url == null ? null : url.trim();
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public POperationLog withGmtCreate(Date gmtCreate) {
        this.setGmtCreate(gmtCreate);
        return this;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", userNo=").append(userNo);
        sb.append(", content=").append(content);
        sb.append(", opType=").append(opType);
        sb.append(", ipAddr=").append(ipAddr);
        sb.append(", success=").append(success);
        sb.append(", url=").append(url);
        sb.append(", gmtCreate=").append(gmtCreate);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        POperationLog other = (POperationLog) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getUserNo() == null ? other.getUserNo() == null : this.getUserNo().equals(other.getUserNo()))
            && (this.getContent() == null ? other.getContent() == null : this.getContent().equals(other.getContent()))
            && (this.getOpType() == null ? other.getOpType() == null : this.getOpType().equals(other.getOpType()))
            && (this.getIpAddr() == null ? other.getIpAddr() == null : this.getIpAddr().equals(other.getIpAddr()))
            && (this.getSuccess() == null ? other.getSuccess() == null : this.getSuccess().equals(other.getSuccess()))
            && (this.getUrl() == null ? other.getUrl() == null : this.getUrl().equals(other.getUrl()))
            && (this.getGmtCreate() == null ? other.getGmtCreate() == null : this.getGmtCreate().equals(other.getGmtCreate()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getUserNo() == null) ? 0 : getUserNo().hashCode());
        result = prime * result + ((getContent() == null) ? 0 : getContent().hashCode());
        result = prime * result + ((getOpType() == null) ? 0 : getOpType().hashCode());
        result = prime * result + ((getIpAddr() == null) ? 0 : getIpAddr().hashCode());
        result = prime * result + ((getSuccess() == null) ? 0 : getSuccess().hashCode());
        result = prime * result + ((getUrl() == null) ? 0 : getUrl().hashCode());
        result = prime * result + ((getGmtCreate() == null) ? 0 : getGmtCreate().hashCode());
        return result;
    }
}