package com.help.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.help.annotation.*;
import com.help.common.validate.*;
import com.help.constraint.IHelpDomain;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 对应数据库表 p_menu
 *
 */
public class PMenu implements IHelpDomain {
    @Name("菜单编号")
    @Length(max=60,dbmode=false)
    @Required
    private String menuno;

    @Name("菜单名称")
    @Length(max=80,dbmode=false)
    private String menuname;

    @Name("绑定模块权限")
    @Length(max=20,dbmode=false)
    private String moduleNo;

    @Name("绑定功能权限")
    @Length(max=20,dbmode=false)
    private String op;

    @Name("url")
    @Length(max=250,dbmode=false)
    private String url;

    @Name("上级菜单名称")
    @Length(max=60,dbmode=false)
    private String superMenuno;

    @Name("图标")
    @Length(max=40,dbmode=false)
    private String icon;

    @Name("是否系统菜单(已弃用)")
    private Integer isCore;

    @Name("是否外链")
    @Required
    private Integer outLink;

    @Name("排序号")
    private Integer orderno;

    public String getMenuno() {
        return menuno;
    }

    public PMenu withMenuno(String menuno) {
        this.setMenuno(menuno);
        return this;
    }

    public void setMenuno(String menuno) {
        this.menuno = menuno == null ? null : menuno.trim();
    }

    public String getMenuname() {
        return menuname;
    }

    public PMenu withMenuname(String menuname) {
        this.setMenuname(menuname);
        return this;
    }

    public void setMenuname(String menuname) {
        this.menuname = menuname == null ? null : menuname.trim();
    }

    public String getModuleNo() {
        return moduleNo;
    }

    public PMenu withModuleNo(String moduleNo) {
        this.setModuleNo(moduleNo);
        return this;
    }

    public void setModuleNo(String moduleNo) {
        this.moduleNo = moduleNo == null ? null : moduleNo.trim();
    }

    public String getOp() {
        return op;
    }

    public PMenu withOp(String op) {
        this.setOp(op);
        return this;
    }

    public void setOp(String op) {
        this.op = op == null ? null : op.trim();
    }

    public String getUrl() {
        return url;
    }

    public PMenu withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public void setUrl(String url) {
        this.url = url == null ? null : url.trim();
    }

    public String getSuperMenuno() {
        return superMenuno;
    }

    public PMenu withSuperMenuno(String superMenuno) {
        this.setSuperMenuno(superMenuno);
        return this;
    }

    public void setSuperMenuno(String superMenuno) {
        this.superMenuno = superMenuno == null ? null : superMenuno.trim();
    }

    public String getIcon() {
        return icon;
    }

    public PMenu withIcon(String icon) {
        this.setIcon(icon);
        return this;
    }

    public void setIcon(String icon) {
        this.icon = icon == null ? null : icon.trim();
    }

    public Integer getIsCore() {
        return isCore;
    }

    public PMenu withIsCore(Integer isCore) {
        this.setIsCore(isCore);
        return this;
    }

    public void setIsCore(Integer isCore) {
        this.isCore = isCore;
    }

    public Integer getOutLink() {
        return outLink;
    }

    public PMenu withOutLink(Integer outLink) {
        this.setOutLink(outLink);
        return this;
    }

    public void setOutLink(Integer outLink) {
        this.outLink = outLink;
    }

    public Integer getOrderno() {
        return orderno;
    }

    public PMenu withOrderno(Integer orderno) {
        this.setOrderno(orderno);
        return this;
    }

    public void setOrderno(Integer orderno) {
        this.orderno = orderno;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", menuno=").append(menuno);
        sb.append(", menuname=").append(menuname);
        sb.append(", moduleNo=").append(moduleNo);
        sb.append(", op=").append(op);
        sb.append(", url=").append(url);
        sb.append(", superMenuno=").append(superMenuno);
        sb.append(", icon=").append(icon);
        sb.append(", isCore=").append(isCore);
        sb.append(", outLink=").append(outLink);
        sb.append(", orderno=").append(orderno);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        PMenu other = (PMenu) that;
        return (this.getMenuno() == null ? other.getMenuno() == null : this.getMenuno().equals(other.getMenuno()))
            && (this.getMenuname() == null ? other.getMenuname() == null : this.getMenuname().equals(other.getMenuname()))
            && (this.getModuleNo() == null ? other.getModuleNo() == null : this.getModuleNo().equals(other.getModuleNo()))
            && (this.getOp() == null ? other.getOp() == null : this.getOp().equals(other.getOp()))
            && (this.getUrl() == null ? other.getUrl() == null : this.getUrl().equals(other.getUrl()))
            && (this.getSuperMenuno() == null ? other.getSuperMenuno() == null : this.getSuperMenuno().equals(other.getSuperMenuno()))
            && (this.getIcon() == null ? other.getIcon() == null : this.getIcon().equals(other.getIcon()))
            && (this.getIsCore() == null ? other.getIsCore() == null : this.getIsCore().equals(other.getIsCore()))
            && (this.getOutLink() == null ? other.getOutLink() == null : this.getOutLink().equals(other.getOutLink()))
            && (this.getOrderno() == null ? other.getOrderno() == null : this.getOrderno().equals(other.getOrderno()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getMenuno() == null) ? 0 : getMenuno().hashCode());
        result = prime * result + ((getMenuname() == null) ? 0 : getMenuname().hashCode());
        result = prime * result + ((getModuleNo() == null) ? 0 : getModuleNo().hashCode());
        result = prime * result + ((getOp() == null) ? 0 : getOp().hashCode());
        result = prime * result + ((getUrl() == null) ? 0 : getUrl().hashCode());
        result = prime * result + ((getSuperMenuno() == null) ? 0 : getSuperMenuno().hashCode());
        result = prime * result + ((getIcon() == null) ? 0 : getIcon().hashCode());
        result = prime * result + ((getIsCore() == null) ? 0 : getIsCore().hashCode());
        result = prime * result + ((getOutLink() == null) ? 0 : getOutLink().hashCode());
        result = prime * result + ((getOrderno() == null) ? 0 : getOrderno().hashCode());
        return result;
    }
}