package com.help.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.help.common.validate.*;
import com.help.constraint.IHelpDomain;
import java.util.Date;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 对应数据库表 p_file
 *
 */
public class PFile implements IHelpDomain {
    @Name("文件编号")
    @Length(max=100,dbmode=false)
    private String fileId;

    @Name("文件大小(byte)")
    private Long fileSize;

    @Name("上传时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date gmtCreate;

    @Name("原始文件名")
    @Length(max=200,dbmode=false)
    @Required
    private String originalName;

    @Name("文件MIME")
    @Length(max=100,dbmode=false)
    private String fileMime;

    @Name("上传人")
    @Length(max=20,dbmode=false)
    @Required
    private String inputUser;

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public Long getFileSize() {
        return fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getOriginalName() {
        return originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public String getFileMime() {
        return fileMime;
    }

    public void setFileMime(String fileMime) {
        this.fileMime = fileMime;
    }

    public String getInputUser() {
        return inputUser;
    }

    public void setInputUser(String inputUser) {
        this.inputUser = inputUser;
    }
}