package com.help.dao;

import com.help.domain.PRoleModuleOp;
import com.help.domain.PRoleModuleOpExample;
import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface PRoleModuleOpMapper {
    long countByExample(PRoleModuleOpExample example);

    int deleteByExample(PRoleModuleOpExample example);

    int deleteByPrimaryKey(@Param("roleNo") String roleNo, @Param("moduleNo") String moduleNo, @Param("opNo") String opNo);

    int insert(PRoleModuleOp record);

    int insertSelective(PRoleModuleOp record);

    List<PRoleModuleOp> selectByExample(PRoleModuleOpExample example);

    int updateByExampleSelective(@Param("record") PRoleModuleOp record, @Param("example") PRoleModuleOpExample example);

    int updateByExample(@Param("record") PRoleModuleOp record, @Param("example") PRoleModuleOpExample example);

    /**
     * 根据条件和指定的字段名查询数据
     * @param example 查询条件 若此条件为null则查询所有数据
     * @param fields 要得到的字段(com.help.domain.PRoleModuleOp类的字段名 而不是查询返回的列名) 此方法将自动忽略匹配不到的字段 若此参数为null或length==0 则查询所有字段
     * @return 查询到的结果集
     */
    List<PRoleModuleOp> selectColumnsByExample(@Param("example") PRoleModuleOpExample example, @Param("fields") String... fields);

    /**
     * 根据主键和指定的字段名查询数据
     * @param roleNo 主键字段
     * @param moduleNo 主键字段
     * @param opNo 主键字段
     * @param fields 要查询的字段(com.help.domain.PRoleModuleOp类的字段名 而不是数据库的列名) 此方法将自动忽略匹配不到的字段 若此参数为null或length==0 则查询除主键外所有字段
     * @return 查询到的数据
     */
    PRoleModuleOp selectColumnsByPrimaryKey(@Param("roleNo") String roleNo, @Param("moduleNo") String moduleNo, @Param("opNo") String opNo, @Param("fields") String... fields);

    /**
     * 根据主键和指定的字段名更新非主键字段
     * @param record 要更新的数据 record不能为null
     * @param fields 要更新的字段(com.help.domain.PRoleModuleOp类的字段名 而不是数据库的列名) 此方法将自动忽略主键与匹配不到的字段与主键字段 若此参数为null或size==0 则更新除主键外所有字段
     * @return 受影响的行数
     */
    int updateColumnsByPrimaryKey(@Param("record") PRoleModuleOp record, @Param("fields") String... fields);

    /**
     * 根据条件和指定的字段名更新字段
     * @param record 要更新的数据 record不能为null
     * @param example 更新条件 若此条件为null则更新所有数据
     * @param fields 要更新的字段(com.help.domain.PRoleModuleOp类的字段名 而不是数据库的列名) 此方法将自动忽略主键与匹配不到的字段 若此参数为null或size==0 则更新除主键外所有字段
     * @return 受影响的行数
     */
    int updateColumnsByExample(@Param("record") PRoleModuleOp record, @Param("example") PRoleModuleOpExample example, @Param("fields") String... fields);

    /**
     * 根据主键查询数据并在事务中添加更新锁
     * @param roleNo 主键字段
     * @param moduleNo 主键字段
     * @param opNo 主键字段
     * @return 查询到的数据
     */
    PRoleModuleOp selectByPrimaryKeyForUpdate(@Param("roleNo") String roleNo, @Param("moduleNo") String moduleNo, @Param("opNo") String opNo);
}