package com.help.dao;

import com.help.domain.POperationLog;
import com.help.domain.POperationLogExample;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * 操作日志数据访问模块
 * 对应数据库表 p_operation_log
 * @author: Help-Generator Template By YuBin
 * @Date: 2019/9/29 14:33
 */
@Mapper
public interface POperationLogMapper {
    /**
    * 根据条件统计
    * 
    * @param example 查询条件 若此条件为null则查询表内总数据量
    * @return 统计数量
    */
    long countByExample(POperationLogExample example);

    /**
    * 根据条件删除
    * 
    * @param example 查询条件 若此条件为null则删除所有数据
    * @return 影响记录数
    */
    int deleteByExample(POperationLogExample example);

    /**
    * 根据主键删除
    * 
    * @param id 主键
    * @return 影响记录数
    */
    int deleteByPrimaryKey(Long id);

    /**
    * 插入记录
    * 
    * @param record 要插入的数据 record不能为null
    * @return 插入的记录
    */
    int insert(POperationLog record);

    /**
    * 插入记录(只对record中的非null字段生成插入语句,忽略空字段)
    * 
    * @param record 要插入的数据 record不能为null
    * @return 插入的记录
    */
    int insertSelective(POperationLog record);

    /**
    * 根据条件查询
    * 
    * @param example 查询条件,null则查询所有数据
    * @return 结果集
    */
    List<POperationLog> selectByExample(POperationLogExample example);

    /**
    * 根据主键查询
    * 
    * @param id 主键
    * @return 结果集
    */
    POperationLog selectByPrimaryKey(Long id);

    /**
    * 根据条件更新指定字段(只更新record中非空字段)
    * 
    * @param record  要更新的数据模型
    * @param example 查询条件
    * @return 影响记录数
    */
    int updateByExampleSelective(@Param("record") POperationLog record, @Param("example") POperationLogExample example);

    /**
    * 根据条件更新record中所有字段
    * 
    * @param record  更新来源
    * @param example 查询条件
    * @return 影响记录数
    */
    int updateByExample(@Param("record") POperationLog record, @Param("example") POperationLogExample example);

    /**
    * 根据主键更新指定字段(只更新record中非空字段)
    * 
    * @param record  更新来源
    * @return 影响记录数
    */
    int updateByPrimaryKeySelective(POperationLog record);

    /**
    * 根据主键更新record中所有字段
    * 
    * @param record  更新来源
    * @return 影响记录数
    */
    int updateByPrimaryKey(POperationLog record);

    /**
     * 根据条件和指定的字段名查询数据
     * @param example 查询条件 若此条件为null则查询所有数据
     * @param fields 要得到的字段(com.help.domain.POperationLog类的字段名 而不是查询返回的列名) 此方法将自动忽略匹配不到的字段 若此参数为null或length==0 则查询所有字段
     * @return 查询到的结果集
     */
    List<POperationLog> selectColumnsByExample(@Param("example") POperationLogExample example, @Param("fields") String... fields);

    /**
     * 根据主键和指定的字段名查询数据
     * @param id 主键字段
     * @param fields 要查询的字段(com.help.domain.POperationLog类的字段名 而不是数据库的列名) 此方法将自动忽略匹配不到的字段 若此参数为null或length==0 则查询除主键外所有字段
     * @return 查询到的数据
     */
    POperationLog selectColumnsByPrimaryKey(@Param("id") Long id, @Param("fields") String... fields);

    /**
     * 根据主键和指定的字段名更新非主键字段
     * @param record 要更新的数据 record不能为null
     * @param fields 要更新的字段(com.help.domain.POperationLog类的字段名 而不是数据库的列名) 此方法将自动忽略主键与匹配不到的字段与主键字段 若此参数为null或size==0 则更新除主键外所有字段
     * @return 受影响的行数
     */
    int updateColumnsByPrimaryKey(@Param("record") POperationLog record, @Param("fields") String... fields);

    /**
     * 根据条件和指定的字段名更新字段
     * @param record 要更新的数据 record不能为null
     * @param example 更新条件 若此条件为null则更新所有数据
     * @param fields 要更新的字段(com.help.domain.POperationLog类的字段名 而不是数据库的列名) 此方法将自动忽略主键与匹配不到的字段 若此参数为null或size==0 则更新除主键外所有字段
     * @return 受影响的行数
     */
    int updateColumnsByExample(@Param("record") POperationLog record, @Param("example") POperationLogExample example, @Param("fields") String... fields);

    /**
     * 根据条件查询满足条件的第一条数据
     * @param example 查询条件 若此条件为null则不限制查询条件
     * @return 查询到的结果集
     */
    POperationLog selectByExampleFirst(POperationLogExample example);

    /**
     * 根据条件查询满足条件的前N条数据
     * @param example 查询条件 若此条件为null则不限制查询条件
     * @param limit 返回的行数
     * @return 查询到的结果集
     */
    List<POperationLog> selectByExampleLimit(@Param("example") POperationLogExample example, @Param("limit") int limit);

    /**
     * 根据条件和指定的字段名查询满足条件的第一条数据
     * @param example 查询条件 若此条件为null则不限制查询条件
     * @param fields 要得到的字段(com.help.domain.POperationLog类的字段名 而不是查询返回的列名) 此方法将自动忽略匹配不到的字段 若此参数为null或length==0 则查询所有字段
     * @return 查询到的结果集
     */
    POperationLog selectColumnsByExampleFirst(@Param("example") POperationLogExample example, @Param("fields") String... fields);

    /**
     * 根据条件和指定的字段名查询满足条件的前N条数据
     * @param example 查询条件 若此条件为null则不限制查询条件
     * @param limit 返回的行数
     * @param fields 要得到的字段(com.help.domain.POperationLog类的字段名 而不是查询返回的列名) 此方法将自动忽略匹配不到的字段 若此参数为null或length==0 则查询所有字段
     * @return 查询到的结果集
     */
    List<POperationLog> selectColumnsByExampleLimit(@Param("example") POperationLogExample example, @Param("limit") int limit, @Param("fields") String... fields);

    /**
     * 根据主键查询数据并在事务中添加更新锁
     * @param id 主键字段
     * @return 查询到的数据
     */
    POperationLog selectByPrimaryKeyForUpdate(@Param("id") Long id);
}