package com.help.common;

import com.help.common.tuple.Tuple2;
import com.help.common.util.StringUtil;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.Random;

/**
 * HELP管理平台系统工具
 *
 * @author: YuBin-002726
 * @Date: 2019/10/10 13:41
 */
public class HelpManageUtil {

    private HelpManageUtil() {
    }

    /**
     * 强密码校验
     *
     * @param password
     * @return 是否强密码
     */
    public static boolean strongCipherValid(String password) {
        //校验密码长度
        if (StringUtil.isNotEmpty(password) && password.length() >= 8) {
            //检测连续字符
            StringBuilder sample = new StringBuilder("abcdefghijklmnopqrstuvwxyz01234567890`1234567890-=qwertyuiop[]\\asdfghjkl;'zxcvbnm,./");
            if (sample.indexOf(password) >= 0) {
                return false;
            }
            if (sample.reverse().indexOf(password) >= 0) {
                return false;
            }

            //校验密码包含数字,大写字母,小写字母,符号中的三种
            int num = 0;
            int lower = 0;
            int upper = 0;
            int other = 0;
            for (int i = 0; i < password.length(); i++) {
                char c = password.charAt(i);
                if (c >= '0' && c <= '9') {
                    num = 1;
                } else if (c >= 'a' && c <= 'z') {
                    lower = 1;
                } else if (c >= 'A' && c <= 'Z') {
                    upper = 1;
                } else if (c >= 33 && c <= 47 || c >= 58 && c <= 64 || c >= 91 && c <= 96 || c >= 123 && c <= 126) {
                    other = 1;
                }
            }
            if (num + lower + upper + other < 3) {
                return false;
            }
            return true;
        } else {
            return false;
        }
    }


    //给缓冲区添加字符串,添加干扰线
    public static Tuple2<String, BufferedImage> getValidCodeImage(int count) {
        int x = 60 * count;
        int y = 100;
        int fontSize = 70;
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        Color bgColor = new Color(255, 255, 255);
        String[] fontsName = {"宋体", "华文楷体", "黑体", "华文新魏", "华文隶书", "微软雅黑", "楷体_GB2312"};
        String codes = "23456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ";

        BufferedImage bi = new BufferedImage(x, y, BufferedImage.TYPE_INT_RGB);
        Graphics2D pen = (Graphics2D) bi.getGraphics();
        pen.setColor(bgColor);
        pen.fillRect(0, 0, x, y);

        pen.shear(-0.1, 0.2);

        for (int i = 0; i < count; i++) {
            int red = random.nextInt(150);
            int green = random.nextInt(150);
            int blue = random.nextInt(150);
            Color color = new Color(red, green, blue);

            int index = random.nextInt(fontsName.length);
            String font = fontsName[index];
            int style = random.nextInt(4);
            pen.setColor(color);
            pen.setFont(new Font(font, style, fontSize));
            index = random.nextInt(codes.length());
            String s = String.valueOf(codes.charAt(index));
            sb.append(s);

            if (i % 2 == 0) {
                pen.shear(0.2, -0.4);
                pen.drawString(s, i * 45, 70 + i * 10);
            } else {
                pen.shear(-0.2, 0.4);
                pen.drawString(s, i * 45, 70 - i * 10);
            }

        }
        int lineNumber = 5;
        pen = (Graphics2D) bi.getGraphics();
        pen.setColor(Color.RED);
//		pen.setStroke(new BasicStroke(1.5F));
        pen.setStroke(new BasicStroke(1.5F, BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER));
        for (int i = 0; i < lineNumber; i++) {
            int x1 = random.nextInt(x / 10);
            int y1 = random.nextInt(y);
            int x2 = random.nextInt(x * 10);
            int y2 = random.nextInt(y);
            pen.drawLine(x1, y1, x2, y2);
        }
        return new Tuple2<>(sb.toString(), bi);
    }


}
