package com.help;

import com.help.common.UnifyPageData;
import com.help.constraint.IHelpDomain;
import com.help.constraint.IHelpExample;
import com.help.constraint.ISearchable;
import com.help.service.DictionaryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.*;

/**
 * 转码工具
 *
 * @author YuBin-002726
 */
@Component
public class TranscodeBuilder {

    private Map<String, ISearchable<?, IHelpExample<?, ?>>> services = null;            //以Domain类的完全限定名为Key,Service类为Value
    private Map<String, Class<?>> examples = null;                                        //以Domain类的完全限定名为Key,Method的参数类型为Value
    private DictionaryService dictionaryService;

    public TranscodeBuilder(@Autowired(required = false) DictionaryService dictionaryService, @Autowired(required = false) List<ISearchable> iSearchables) {

        this.services = new HashMap<>();
        this.examples = new HashMap<>();
        this.dictionaryService = dictionaryService;


        if (iSearchables != null) {
          //  Set<Class> sers = new HashSet<>();

            for (ISearchable s : iSearchables) {

                Class trueCls = s.getClass();

                while (trueCls != null) {
                    boolean find = false;
                    Type[] itfs = trueCls.getGenericInterfaces();
                    for (Type t : itfs) {
                        if (t instanceof ParameterizedType) {
                            ParameterizedType pt = (ParameterizedType) t;
                            Type r = pt.getRawType();
                            if (r instanceof Class && ISearchable.class.isAssignableFrom((Class) r)) {
                                Type[] args = pt.getActualTypeArguments();

                                Class<?> returnType = (Class<?>) args[0];
                                Class<?> exampleType = (Class<?>) args[1];
                                if (IHelpDomain.class.isAssignableFrom(returnType) && IHelpExample.class.isAssignableFrom(exampleType)) {
                                    services.put(returnType.getName(), s);
                                    examples.put(returnType.getName(), exampleType);
                                    find = true;
                                    break;
                                }
                            }
                        }
                    }
                    if (!find) {
                        trueCls = trueCls.getSuperclass();
                    } else {
                        break;
                    }
                }
            }
        }


    }


    /**
     * 使用给定实体对象构造转码器 一旦匹配到数据 将以bean中原字段+"_displayname"的名字添加进bean中
     *
     * @param entity 要转码的对象
     * @return 转码器
     */
    public Transcoder build(IHelpDomain entity) {
        Transcoder transcoder = new Transcoder(entity, false);
        transcoder.init(services, examples, dictionaryService);
        return transcoder;
    }

    /**
     * 使用给定分页数据构造转码器 一旦匹配到数据 将以bean中原字段+"_displayname"的名字添加进bean中
     *
     * @param pagedList 要转码的分页数据
     * @return 转码器
     */
    public <T extends IHelpDomain> Transcoder build(UnifyPageData<T> pagedList) {
        Transcoder transcoder = new Transcoder(pagedList, false);
        transcoder.init(services, examples, dictionaryService);
        return transcoder;
    }

    /**
     * 使用给定可迭代集合构造转码器 一旦匹配到数据 将以bean中原字段+"_displayname"的名字添加进bean中
     *
     * @param list 要转码的迭代集合
     * @return 转码器
     */
    public <T extends IHelpDomain> Transcoder build(Iterable<T> list) {
        Transcoder transcoder = new Transcoder(list, false);
        transcoder.init(services, examples, dictionaryService);
        return transcoder;
    }

    /**
     * 使用给定数组构造转码器 一旦匹配到数据 将以bean中原字段+"_displayname"的名字添加进bean中
     *
     * @param array 要转码的数组
     * @return 转码器
     */
    public <T extends IHelpDomain> Transcoder build(T[] array) {
        Transcoder transcoder = new Transcoder(array, false);
        transcoder.init(services, examples, dictionaryService);
        return transcoder;
    }

    /**
     * 使用给定实体对象,对象数组,集合或UnifyPageData分页数据和转码模式构造转码器 一旦匹配到数据 将以bean中原字段+"_displayname"的名字添加进bean中
     *
     * @param data 要转码的对象 可以是一个实体bean或实体bean数组/集合,或者UnifyPageData分页数据
     * @return 转码器
     */
    public Transcoder build(Object data) {
        if (data instanceof Transcoder) {
            return (Transcoder) data;
        } else {
            Transcoder transcoder = new Transcoder(data, false);
            transcoder.init(services, examples, dictionaryService);
            return transcoder;
        }
    }
}