/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.help.domain.OrgInfoBase;
import com.help.domain.OrgNode;
import com.help.storage.IOrgStorage;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractOrgStorage
implements IOrgStorage {
    private void removeChild(OrgNode node, int currentLevel, int maxLevel) {
        if (currentLevel >= maxLevel) {
            node.setChildren(null);
        } else if (node.getChildren() != null) {
            for (OrgNode n : node.getChildren()) {
                this.removeChild(n, currentLevel + 1, maxLevel);
            }
        }
    }

    private OrgNode findOrg(List<OrgNode> list, String orgNo) {
        for (OrgNode node : list) {
            OrgNode find;
            if (node.getOrgNo().equalsIgnoreCase(orgNo)) {
                return node;
            }
            if (node.getChildren() == null || node.getChildren().size() <= 0 || (find = this.findOrg(node.getChildren(), orgNo)) == null) continue;
            return find;
        }
        return null;
    }

    @Override
    public List<OrgInfoBase> listByType(String type) {
        return this.listAll().stream().filter(p -> p.getType().equalsIgnoreCase(type)).collect(Collectors.toList());
    }

    @Override
    public OrgInfoBase get(String orgNo) {
        List<OrgInfoBase> orgs = this.getAll(orgNo);
        if (orgs.size() > 0) {
            return orgs.get(0);
        }
        return null;
    }

    @Override
    public OrgNode getWithChilds(String orgNo) {
        return this.getWithChilds(orgNo, 1);
    }

    @Override
    public OrgNode getWithChilds(String orgNo, int level) {
        OrgNode node = this.getWithAll(orgNo);
        if (node != null) {
            this.removeChild(node, 0, level);
            return node;
        }
        return null;
    }

    @Override
    public OrgNode getWithAll(String orgNo) {
        return this.findOrg(this.listTopWithAll(), orgNo);
    }

    @Override
    public List<OrgInfoBase> listTop() {
        return this.listTopWithAll().stream().map(p -> this.transform((OrgNode)p)).collect(Collectors.toList());
    }

    @Override
    public List<OrgNode> listTopWithChilds() {
        List<OrgNode> all = this.listTopWithAll();
        for (OrgNode lv2 : all) {
            if (lv2.getChildren() == null) continue;
            for (OrgNode cld : lv2.getChildren()) {
                cld.setChildren(null);
            }
        }
        return all;
    }

    private OrgInfoBase transform(OrgNode p) {
        OrgInfoBase base = new OrgInfoBase();
        base.setState(p.getState());
        base.setLegalPersonality(p.getLegalPersonality());
        base.setOrgName(p.getOrgName());
        base.setOrgNo(p.getOrgNo());
        base.setRemark(p.getRemark());
        base.setTags(p.getTags());
        base.setAddress(p.getAddress());
        base.setParentNo(p.getParentNo());
        base.setType(p.getType());
        return base;
    }
}

