/*
 * Decompiled with CFR 0.152.
 */
package com.help.web;

import com.help.common.UnifyPageData;
import com.help.constraint.IHelpDomain;
import com.help.constraint.IHelpExample;
import com.help.constraint.ISearchable;
import com.help.service.IDicService;
import com.help.web.Transcoder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TranscodeBuilder {
    private Map<String, ISearchable<?, IHelpExample<?, ?>>> services = new HashMap();
    private Map<String, Class<?>> examples = new HashMap();
    private IDicService dictionaryService;

    public TranscodeBuilder(IDicService dictionaryService, List<ISearchable> iSearchables) {
        this.dictionaryService = dictionaryService;
        if (iSearchables != null) {
            block0: for (ISearchable s : iSearchables) {
                for (Class<?> trueCls = s.getClass(); trueCls != null; trueCls = trueCls.getSuperclass()) {
                    Type[] itfs;
                    boolean find = false;
                    for (Type t : itfs = trueCls.getGenericInterfaces()) {
                        ParameterizedType pt;
                        Type r;
                        if (!(t instanceof ParameterizedType) || !((r = (pt = (ParameterizedType)t).getRawType()) instanceof Class) || !ISearchable.class.isAssignableFrom((Class)r)) continue;
                        Type[] args = pt.getActualTypeArguments();
                        Class returnType = (Class)args[0];
                        Class exampleType = (Class)args[1];
                        if (!IHelpDomain.class.isAssignableFrom(returnType) || !IHelpExample.class.isAssignableFrom(exampleType)) continue;
                        this.services.put(returnType.getName(), s);
                        this.examples.put(returnType.getName(), exampleType);
                        find = true;
                        break;
                    }
                    if (find) continue block0;
                }
            }
        }
    }

    public Transcoder build(IHelpDomain entity) {
        Transcoder transcoder = new Transcoder(entity, false);
        transcoder.init(this.services, this.examples, this.dictionaryService);
        return transcoder;
    }

    public <T extends IHelpDomain> Transcoder build(UnifyPageData<T> pagedList) {
        Transcoder transcoder = new Transcoder(pagedList, false);
        transcoder.init(this.services, this.examples, this.dictionaryService);
        return transcoder;
    }

    public <T extends IHelpDomain> Transcoder build(Iterable<T> list) {
        Transcoder transcoder = new Transcoder(list, false);
        transcoder.init(this.services, this.examples, this.dictionaryService);
        return transcoder;
    }

    public <T extends IHelpDomain> Transcoder build(T[] array) {
        Transcoder transcoder = new Transcoder(array, false);
        transcoder.init(this.services, this.examples, this.dictionaryService);
        return transcoder;
    }

    public Transcoder build(Object data) {
        if (data instanceof Transcoder) {
            return (Transcoder)data;
        }
        Transcoder transcoder = new Transcoder(data, false);
        transcoder.init(this.services, this.examples, this.dictionaryService);
        return transcoder;
    }
}

