/*
 * Decompiled with CFR 0.152.
 */
package com.help.cache;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.util.ClassUtils;

public class HelpCacheKeyGenerator
implements KeyGenerator {
    private static final int NO_PARAM_KEY = 0;
    private static final int NULL_PARAM_KEY = 53;

    public Object generate(Object target, Method method, Object ... params) {
        StringBuffer key = new StringBuffer();
        key.append(target.getClass().getSimpleName()).append(".").append(method.getName()).append(":");
        if (params.length == 0) {
            key.append(0).toString();
        } else {
            for (Object param : params) {
                if (param == null) {
                    key.append(53);
                } else if (ClassUtils.isPrimitiveArray(param.getClass())) {
                    int length = Array.getLength(param);
                    for (int i = 0; i < length; ++i) {
                        key.append(Array.get(param, i));
                        key.append(",");
                    }
                } else if (ClassUtils.isPrimitiveOrWrapper(param.getClass()) || param instanceof String) {
                    key.append(param);
                } else {
                    key.append(param.hashCode());
                }
                key.append("-");
            }
        }
        String k = key.toString();
        return k;
    }
}

