/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.help.dao.PTreeDicMapper;
import com.help.domain.DicType;
import com.help.domain.PTreeDic;
import com.help.domain.PTreeDicExample;
import com.help.domain.TreeDicItem;
import com.help.storage.editable.IEditableTreeDicStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class HelpLocalTreeDicStorage
implements IEditableTreeDicStorage {
    @Autowired
    private PTreeDicMapper pTreeDicMapper;

    public List<TreeDicItem> list(String type) {
        PTreeDicExample example = new PTreeDicExample();
        example.createCriteria().andDicTypeEqualTo(type);
        return this.pTreeDicMapper.selectByExample(example).stream().map(p -> this.transform((PTreeDic)p)).sorted().collect(Collectors.toList());
    }

    public TreeDicItem get(String type, String code) {
        return this.transform(this.pTreeDicMapper.selectByPrimaryKey(type, code));
    }

    public List<DicType> listTypes() {
        PTreeDicExample example = new PTreeDicExample();
        example.createCriteria().andParentCodeIsEmpty();
        example.setDistinct(true);
        return this.pTreeDicMapper.selectColumnsByExample(example, "dicType").stream().map(p -> {
            DicType type = new DicType();
            type.setDicType(p.getDicType());
            type.setText(p.getDicType());
            return type;
        }).collect(Collectors.toList());
    }

    public void add(TreeDicItem dicItem) {
        PTreeDic dic = this.transform(dicItem);
        this.pTreeDicMapper.insert(dic);
    }

    private void fillChilds(List<TreeDicItem> all, String code, List<String> result) {
        result.add(code);
        for (TreeDicItem item : all) {
            if (!code.equalsIgnoreCase(item.getParent())) continue;
            this.fillChilds(all, item.getCode(), result);
        }
    }

    @Transactional
    public void delete(String type, String code) {
        PTreeDicExample example = new PTreeDicExample();
        example.createCriteria().andDicTypeEqualTo(type).andParentCodeEqualTo(code);
        PTreeDic dic = new PTreeDic();
        this.pTreeDicMapper.updateColumnsByExample(dic, example, "parentCode");
        this.pTreeDicMapper.deleteByPrimaryKey(type, code);
    }

    public void deleteAll(String type, String code) {
        List<TreeDicItem> items = this.list(type);
        if (items.stream().filter(p -> p.getCode().equalsIgnoreCase(code)).count() > 0L) {
            ArrayList<String> codes = new ArrayList<String>();
            this.fillChilds(items, code, codes);
            PTreeDicExample example = new PTreeDicExample();
            example.createCriteria().andDicTypeEqualTo(type).andCodeIn(codes);
            this.pTreeDicMapper.deleteByExample(example);
        }
    }

    public void edit(TreeDicItem dicItem) {
        PTreeDic dic = this.transform(dicItem);
        this.pTreeDicMapper.updateByPrimaryKey(dic);
    }

    private TreeDicItem transform(PTreeDic dic) {
        if (dic == null) {
            return null;
        }
        TreeDicItem dicItem = new TreeDicItem(dic.getCode(), dic.getText(), dic.getParentCode(), dic.getDicType());
        dicItem.setRemark(dic.getRemark());
        dicItem.setParent(dic.getParentCode());
        return dicItem;
    }

    private PTreeDic transform(TreeDicItem dicItem) {
        if (dicItem == null) {
            return null;
        }
        PTreeDic dic = new PTreeDic();
        dic.setText(dicItem.getText());
        dic.setRemark(dicItem.getRemark());
        dic.setCode(dicItem.getCode());
        dic.setParentCode(dicItem.getParent());
        dic.setDicType(dicItem.getDicType());
        return dic;
    }
}

