/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.util.StringUtil;
import com.help.dao.PDicMapper;
import com.help.domain.DicItem;
import com.help.domain.DicType;
import com.help.domain.PDic;
import com.help.domain.PDicExample;
import com.help.storage.editable.IEditableDicStorage;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class HelpLocalDicStorage
implements IEditableDicStorage {
    @Autowired
    private PDicMapper pDicMapper;

    public List<DicItem> list(String type) {
        PDicExample example = new PDicExample();
        example.createCriteria().andDicTypeEqualTo(type);
        return this.pDicMapper.selectByExample(example).stream().map(p -> this.transform((PDic)p)).sorted().collect(Collectors.toList());
    }

    public DicItem get(String type, String code) {
        return this.transform(this.pDicMapper.selectByPrimaryKey(type, code));
    }

    public UnifyPageData<DicItem> searchByPage(String type, UnifyPageInfo pageInfo) {
        PDicExample example = new PDicExample();
        if (StringUtil.isNotEmpty((String)type)) {
            example.createCriteria().andDicTypeEqualTo(type);
        }
        example.setOrderByClause("dic_type");
        PageHelper.startPage((int)pageInfo.getPageIndex(), (int)pageInfo.getPageSize());
        List<PDic> list = this.pDicMapper.selectByExample(example);
        PageInfo info = new PageInfo(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData((Collection)info.getList().stream().map(p -> this.transform((PDic)p)).sorted().collect(Collectors.toList()), pageInfo);
    }

    public List<DicType> listTypes() {
        PDicExample example = new PDicExample();
        example.setDistinct(true);
        return this.pDicMapper.selectColumnsByExample(example, "dicType").stream().map(p -> {
            DicType type = new DicType();
            type.setDicType(p.getDicType());
            type.setText(p.getDicType());
            return type;
        }).collect(Collectors.toList());
    }

    public void add(DicItem dicItem) {
        PDic dic = this.transform(dicItem);
        this.pDicMapper.insert(dic);
    }

    public void delete(String type, String code) {
        this.pDicMapper.deleteByPrimaryKey(type, code);
    }

    public void edit(DicItem dicItem) {
        PDic dic = this.transform(dicItem);
        this.pDicMapper.updateByPrimaryKey(dic);
    }

    private DicItem transform(PDic dic) {
        if (dic == null) {
            return null;
        }
        DicItem dicItem = new DicItem(dic.getCode(), dic.getText(), dic.getDicType());
        dicItem.setRemark(dic.getRemark());
        return dicItem;
    }

    private PDic transform(DicItem dicItem) {
        if (dicItem == null) {
            return null;
        }
        PDic dic = new PDic();
        dic.setText(dicItem.getText());
        dic.setRemark(dicItem.getRemark());
        dic.setCode(dicItem.getCode());
        dic.setDicType(dicItem.getDicType());
        return dic;
    }
}

