package com.help.storage;

import com.help.dao.PTreeDicMapper;
import com.help.domain.*;
import com.help.storage.editable.IEditableTreeDicStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: YuBin-002726
 * @Date: 2019/3/1 17:42
 */
public class HelpLocalTreeDicStorage implements IEditableTreeDicStorage {

    @Autowired
    private PTreeDicMapper pTreeDicMapper;

    @Override
    public List<TreeDicItem> list(String type) {
        PTreeDicExample example = new PTreeDicExample();
        example.createCriteria().andDicTypeEqualTo(type);

        return pTreeDicMapper.selectByExample(example).stream().map(p -> transform(p)).sorted().collect(Collectors.toList());
    }

    @Override
    public TreeDicItem get(String type, String code) {
        return transform(pTreeDicMapper.selectByPrimaryKey(type, code));
    }

    @Override
    public List<DicType> listTypes() {
        PTreeDicExample example = new PTreeDicExample();
        example.createCriteria().andParentCodeIsEmpty();
        example.setDistinct(true);

        return pTreeDicMapper.selectColumnsByExample(example, "dicType").stream().map(p -> {
            DicType type = new DicType();
            type.setDicType(p.getDicType());
            type.setText(p.getDicType());
            return type;
        }).collect(Collectors.toList());
    }

    @Override
    public void add(TreeDicItem dicItem) {
        PTreeDic dic = transform(dicItem);

        pTreeDicMapper.insert(dic);
    }

    private void fillChilds(List<TreeDicItem> all, String code, List<String> result) {
        result.add(code);
        for (TreeDicItem item : all) {
            if (code.equalsIgnoreCase(item.getParent())) {
                fillChilds(all, item.getCode(), result);
            }
        }
    }

    @Override
    @Transactional
    public void delete(String type, String code) {
        //将子节点移入根
        PTreeDicExample example = new PTreeDicExample();
        example.createCriteria().andDicTypeEqualTo(type).andParentCodeEqualTo(code);

        PTreeDic dic = new PTreeDic();
        pTreeDicMapper.updateColumnsByExample(dic, example, "parentCode");

        //删除节点
        pTreeDicMapper.deleteByPrimaryKey(type, code);
    }

    @Override
    public void deleteAll(String type, String code) {
        //列出所有项
        List<TreeDicItem> items = list(type);
        if (items.stream().filter(p -> p.getCode().equalsIgnoreCase(code)).count() > 0) {
            List<String> codes = new ArrayList<>();
            fillChilds(items, code, codes);

            PTreeDicExample example = new PTreeDicExample();
            example.createCriteria().andDicTypeEqualTo(type).andCodeIn(codes);

            pTreeDicMapper.deleteByExample(example);
        }
    }

    @Override
    public void edit(TreeDicItem dicItem) {
        PTreeDic dic = transform(dicItem);

        pTreeDicMapper.updateByPrimaryKey(dic);
    }

    private TreeDicItem transform(PTreeDic dic) {
        if (dic == null) {
            return null;
        }

        TreeDicItem dicItem = new TreeDicItem(dic.getCode(), dic.getText(), dic.getParentCode(), dic.getDicType());
        dicItem.setRemark(dic.getRemark());
        dicItem.setParent(dic.getParentCode());
        return dicItem;
    }

    private PTreeDic transform(TreeDicItem dicItem) {
        if (dicItem == null) {
            return null;
        }

        PTreeDic dic = new PTreeDic();
        dic.setText(dicItem.getText());
        dic.setRemark(dicItem.getRemark());
        dic.setCode(dicItem.getCode());
        dic.setParentCode(dicItem.getParent());
        dic.setDicType(dicItem.getDicType());
        return dic;
    }
}
