package com.help.storage;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.util.StringUtil;
import com.help.dao.PDicMapper;
import com.help.domain.*;
import com.help.storage.editable.IEditableDicStorage;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: YuBin-002726
 * @Date: 2019/3/1 17:41
 */
public class HelpLocalDicStorage implements IEditableDicStorage {

    @Autowired
    private PDicMapper pDicMapper;

    @Override
    public List<DicItem> list(String type) {
        PDicExample example = new PDicExample();
        example.createCriteria().andDicTypeEqualTo(type);

        return pDicMapper.selectByExample(example).stream().map(p -> transform(p)).sorted().collect(Collectors.toList());
    }

    @Override
    public DicItem get(String type, String code) {
        return transform(pDicMapper.selectByPrimaryKey(type, code));
    }

    @Override
    public UnifyPageData<DicItem> searchByPage(String type, UnifyPageInfo pageInfo) {
        PDicExample example = new PDicExample();
        if (StringUtil.isNotEmpty(type)) {
            example.createCriteria().andDicTypeEqualTo(type);
        }

        example.setOrderByClause("dic_type");

        PageHelper.startPage(pageInfo.getPageIndex(), pageInfo.getPageSize());
        List<PDic> list = pDicMapper.selectByExample(example);
        PageInfo<PDic> info = new PageInfo(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData<>(info.getList().stream().map(p -> transform(p)).sorted().collect(Collectors.toList()), pageInfo);
    }

    @Override
    public List<DicType> listTypes() {
        PDicExample example = new PDicExample();
        example.setDistinct(true);

        return pDicMapper.selectColumnsByExample(example, "dicType").stream().map(p -> {
            DicType type = new DicType();
            type.setDicType(p.getDicType());
            type.setText(p.getDicType());
            return type;
        }).collect(Collectors.toList());
    }

    @Override
    public void add(DicItem dicItem) {
        PDic dic = transform(dicItem);

        pDicMapper.insert(dic);
    }

    @Override
    public void delete(String type, String code) {
        pDicMapper.deleteByPrimaryKey(type, code);
    }

    @Override
    public void edit(DicItem dicItem) {
        PDic dic = transform(dicItem);

        pDicMapper.updateByPrimaryKey(dic);
    }

    private DicItem transform(PDic dic) {
        if (dic == null) {
            return null;
        }

        DicItem dicItem = new DicItem(dic.getCode(), dic.getText(), dic.getDicType());
        dicItem.setRemark(dic.getRemark());
        return dicItem;
    }

    private PDic transform(DicItem dicItem) {
        if (dicItem == null) {
            return null;
        }

        PDic dic = new PDic();
        dic.setText(dicItem.getText());
        dic.setRemark(dicItem.getRemark());
        dic.setCode(dicItem.getCode());
        dic.setDicType(dicItem.getDicType());
        return dic;
    }

}
