package com.help.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.help.annotation.*;
import com.help.common.validate.*;
import com.help.constraint.IHelpDomain;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 对应数据库表 p_tree_dic
 *
 */
public class PTreeDic implements IHelpDomain {
    @Name("类型名")
    @Length(max=20,dbmode=false)
    @Required
    private String dicType;

    @Name("字典码")
    @Length(max=20,dbmode=false)
    @Required
    private String code;

    @Name("字典文本")
    @Length(max=100,dbmode=false)
    private String text;

    @Name("上级字典码")
    @Length(max=20,dbmode=false)
    private String parentCode;

    @Name("备注")
    @Length(max=200,dbmode=false)
    private String remark;

    public String getDicType() {
        return dicType;
    }

    public PTreeDic withDicType(String dicType) {
        this.setDicType(dicType);
        return this;
    }

    public void setDicType(String dicType) {
        this.dicType = dicType == null ? null : dicType.trim();
    }

    public String getCode() {
        return code;
    }

    public PTreeDic withCode(String code) {
        this.setCode(code);
        return this;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public String getText() {
        return text;
    }

    public PTreeDic withText(String text) {
        this.setText(text);
        return this;
    }

    public void setText(String text) {
        this.text = text == null ? null : text.trim();
    }

    public String getParentCode() {
        return parentCode;
    }

    public PTreeDic withParentCode(String parentCode) {
        this.setParentCode(parentCode);
        return this;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode == null ? null : parentCode.trim();
    }

    public String getRemark() {
        return remark;
    }

    public PTreeDic withRemark(String remark) {
        this.setRemark(remark);
        return this;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", dicType=").append(dicType);
        sb.append(", code=").append(code);
        sb.append(", text=").append(text);
        sb.append(", parentCode=").append(parentCode);
        sb.append(", remark=").append(remark);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        PTreeDic other = (PTreeDic) that;
        return (this.getDicType() == null ? other.getDicType() == null : this.getDicType().equals(other.getDicType()))
            && (this.getCode() == null ? other.getCode() == null : this.getCode().equals(other.getCode()))
            && (this.getText() == null ? other.getText() == null : this.getText().equals(other.getText()))
            && (this.getParentCode() == null ? other.getParentCode() == null : this.getParentCode().equals(other.getParentCode()))
            && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getDicType() == null) ? 0 : getDicType().hashCode());
        result = prime * result + ((getCode() == null) ? 0 : getCode().hashCode());
        result = prime * result + ((getText() == null) ? 0 : getText().hashCode());
        result = prime * result + ((getParentCode() == null) ? 0 : getParentCode().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        return result;
    }
}