package com.help;

import com.help.storage.HelpLocalTreeDicStorage;
import com.help.storage.ITreeDicStorage;
import com.help.storage.editable.IEditableTreeDicStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * HELP平台本地树形字典模块
 */
public class HelpLocalTreeDicAutoConfiguration {

    Logger logger = LoggerFactory.getLogger(HelpLocalTreeDicAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean({IEditableTreeDicStorage.class, ITreeDicStorage.class})
    public IEditableTreeDicStorage iEditableTreeDicStorage() {
        IEditableTreeDicStorage userService = new HelpLocalTreeDicStorage();

        logger.info("检测到[本地树形字典模块],自动配置[HELP平台树形字典服务]");

        return userService;
    }

}
