package com.help;

import com.help.storage.HelpLocalDicStorage;
import com.help.storage.IDicStorage;
import com.help.storage.editable.IEditableDicStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * HELP平台本地字典模块
 */
public class HelpLocalDicAutoConfiguration {

    Logger logger = LoggerFactory.getLogger(HelpLocalDicAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean({IEditableDicStorage.class, IDicStorage.class})
    public IEditableDicStorage iEditableDicStorage() {
        IEditableDicStorage userService = new HelpLocalDicStorage();

        logger.info("检测到[本地字典模块],自动配置[HELP平台字典服务]");

        return userService;
    }

}
