/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.help.SpringScanConfig;
import com.help.datasource.config.HelpMybatisConfig;
import com.help.datasource.config.MyBatisSpringSupportConfig;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

@ConditionalOnClass(value={MapperScannerConfigurer.class, SqlSessionFactory.class})
public class HelpMyBatisConfigAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="help.mybatis")
    @ConditionalOnMissingBean(value={HelpMybatisConfig.class})
    public HelpMybatisConfig helpMybatisConfig() {
        return new HelpMybatisConfig();
    }

    @Bean
    public SpringScanConfig springScanConfig(ApplicationContext applicationContext) {
        String[] scanNames;
        String[] names;
        List<String> pkgs = AutoConfigurationPackages.get((BeanFactory)applicationContext);
        for (String appName : names = applicationContext.getBeanNamesForAnnotation(SpringBootApplication.class)) {
            SpringBootApplication anno = (SpringBootApplication)applicationContext.findAnnotationOnBean(appName, SpringBootApplication.class);
            if (anno == null) continue;
            if (anno.scanBasePackages() != null) {
                pkgs.addAll(Arrays.asList(anno.scanBasePackages()));
            }
            if (anno.scanBasePackageClasses() == null) continue;
            for (Class cls : anno.scanBasePackageClasses()) {
                pkgs.add(cls.getPackage().getName());
            }
        }
        for (String scan : scanNames = applicationContext.getBeanNamesForAnnotation(ComponentScan.class)) {
            ComponentScan anno = (ComponentScan)applicationContext.findAnnotationOnBean(scan, ComponentScan.class);
            if (anno == null) continue;
            if (anno.basePackages() != null) {
                pkgs.addAll(Arrays.asList(anno.basePackages()));
            }
            if (anno.value() != null) {
                pkgs.addAll(Arrays.asList(anno.value()));
            }
            if (anno.basePackageClasses() == null) continue;
            for (Class cls : anno.basePackageClasses()) {
                pkgs.add(cls.getPackage().getName());
            }
        }
        pkgs = pkgs.stream().distinct().collect(Collectors.toList());
        SpringScanConfig config = new SpringScanConfig();
        config.setBasePackage(pkgs.toArray(new String[0]));
        return config;
    }

    @Bean
    @ConfigurationProperties(value="mybatis")
    @ConditionalOnMissingBean(value={MyBatisSpringSupportConfig.class})
    public MyBatisSpringSupportConfig myBatisSpringSupportConfig() {
        return new MyBatisSpringSupportConfig();
    }
}

