/*
 * Decompiled with CFR 0.152.
 */
package com.help.common;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.BeanConvert;
import com.help.common.util.StringUtil;
import com.help.config.HelpCrcbIapConfig;
import com.help.config.HelpSystemInfo;
import com.help.crcb.hub.CrcbHubRequestInfo;
import com.help.crcb.hub.CrcbHubResponseCode;
import com.help.crcb.hub.CrcbHubResponseInfo;
import com.help.exception.HelpHystrixBadRequestException;
import com.help.exception.HelpIapException;
import com.help.iap.HelpIapResponseInfo;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Deprecated
public class HelpIapHttpClient {
    Logger logger = LoggerFactory.getLogger(HelpIapHttpClient.class);
    private HelpCrcbIapConfig helpCrcbIapConfig;
    private HelpSystemInfo helpSystemInfo;
    private RestTemplate restTemplate;

    public HelpIapHttpClient(HelpSystemInfo helpSystemInfo, HelpCrcbIapConfig helpCrcbIapConfig, RestTemplate restTemplate) {
        this.helpCrcbIapConfig = helpCrcbIapConfig;
        this.restTemplate = restTemplate;
        this.helpSystemInfo = helpSystemInfo;
    }

    public String buildUrl(String relativeUrl) {
        if (relativeUrl != null && (relativeUrl.toLowerCase().indexOf("http://") == 0 || relativeUrl.toLowerCase().indexOf("https://") == 0)) {
            return relativeUrl;
        }
        if (StringUtil.isNotEmpty((String)this.helpCrcbIapConfig.getGateway())) {
            if (relativeUrl.startsWith("/")) {
                relativeUrl = relativeUrl.substring(1);
            }
            if (this.helpCrcbIapConfig.getGateway().endsWith("/")) {
                return this.helpCrcbIapConfig.getGateway() + relativeUrl;
            }
            return this.helpCrcbIapConfig.getGateway() + "/" + relativeUrl;
        }
        throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u60a8\u5c1a\u672a\u914d\u7f6e[\u4e1a\u52a1\u67a2\u7ebd\u7f51\u5173\u5730\u5740]");
    }

    public HelpIapResponseInfo postGateway(String relativeUrl, CrcbHubRequestInfo request) {
        return this.postGateway(relativeUrl, request, new ParameterizedTypeReference<HelpIapResponseInfo>(){});
    }

    public <T extends CrcbHubResponseInfo> T postGateway(String relativeUrl, CrcbHubRequestInfo request, ParameterizedTypeReference<T> typeReference) {
        relativeUrl = this.buildUrl(relativeUrl);
        return this.post(relativeUrl, request, typeReference);
    }

    public HelpIapResponseInfo post(String url, CrcbHubRequestInfo request) {
        return this.post(url, request, new ParameterizedTypeReference<HelpIapResponseInfo>(){});
    }

    public <T extends CrcbHubResponseInfo> T post(String url, CrcbHubRequestInfo request, ParameterizedTypeReference<T> typeReference) {
        if (StringUtil.isEmpty((String)url) || url.indexOf("http://") != 0 && url.indexOf("https://") != 0) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u8bf7\u6c42URL\u5fc5\u987b\u4ee5http://\u6216https://\u5f00\u5934");
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        ArrayList<MediaType> jsonTypes = new ArrayList<MediaType>();
        jsonTypes.add(MediaType.APPLICATION_JSON);
        httpHeaders.setAccept(jsonTypes);
        HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)httpHeaders);
        ResponseEntity rspEntity = null;
        try {
            rspEntity = this.restTemplate.exchange(url, HttpMethod.POST, entity, typeReference, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            throw new UnifyException(UnifyErrorCode.NON_INTERFACE, "\u670d\u52a1\u5668\u5185\u90e8\u901a\u8baf\u9519\u8bef", (Throwable)e);
        }
        catch (HttpServerErrorException e) {
            throw new UnifyException(UnifyErrorCode.TRANS_UNKNOW, "\u5bf9\u65b9\u670d\u52a1\u5668\u5185\u90e8\u6267\u884c\u9519\u8bef", (Throwable)e);
        }
        catch (ResourceAccessException e) {
            this.logger.warn("\u63a5\u53e3[{}]\u8c03\u7528\u5931\u8d25", (Object)url);
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof UnknownHostException) {
                    throw new UnifyException(UnifyErrorCode.NETWORK_FAIL, "\u670d\u52a1\u5668\u5185\u90e8HTTP\u901a\u8baf\u9519\u8bef,\u8bf7\u6c42\u5730\u5740\u65e0\u6cd5\u89e3\u6790", cause);
                }
                if (cause instanceof ConnectException) {
                    throw new UnifyException(UnifyErrorCode.NETWORK_FAIL, "\u670d\u52a1\u5668\u5185\u90e8HTTP\u901a\u8baf\u9519\u8bef,\u65e0\u6cd5\u8fde\u63a5\u5230\u5bf9\u65b9\u670d\u52a1\u5668", cause);
                }
                if (cause instanceof SocketTimeoutException) {
                    throw new UnifyException(UnifyErrorCode.REQ_TIMEOUT, "\u670d\u52a1\u5668\u5185\u90e8HTTP\u901a\u8baf\u9519\u8bef,\u6570\u636e\u8bfb\u5199\u8d85\u65f6", cause);
                }
                if (cause instanceof IOException) {
                    throw new UnifyException(UnifyErrorCode.REQ_TIMEOUT, "\u670d\u52a1\u5668\u5185\u90e8HTTP\u901a\u8baf\u9519\u8bef,\u6570\u636e\u8bfb\u5199\u5f02\u5e38", cause);
                }
                throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u670d\u52a1\u5668\u5185\u90e8HTTP\u901a\u8baf\u9519\u8bef", cause);
            }
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u670d\u52a1\u5668\u5185\u90e8HTTP\u901a\u8baf\u9519\u8bef", (Throwable)e);
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u670d\u52a1\u5668\u5185\u90e8HTTP\u901a\u8baf\u9519\u8bef", (Throwable)e);
        }
        if (StringUtil.isNotEmpty((Object)rspEntity)) {
            if (rspEntity.getStatusCode() == HttpStatus.OK) {
                CrcbHubResponseInfo responseInfo = (CrcbHubResponseInfo)rspEntity.getBody();
                if (this.helpSystemInfo.getContext().isAutoErrorThrow() && !responseInfo.isSuccess()) {
                    this.logger.warn("HTTP\u901a\u8baf\u670d\u52a1\u7aef\u6267\u884c\u5f02\u5e38: {}", (Object)BeanConvert.toJson((Object)responseInfo));
                    CrcbHubResponseCode[] responseCodes = responseInfo.getResponseHead().getRet();
                    if (responseCodes == null || responseCodes.length == 0) {
                        throw new HelpHystrixBadRequestException(UnifyErrorCode.UNKNOW_FAIL, "\u670d\u52a1\u7aef\u672a\u54cd\u5e94\u6b63\u786e\u7684\u72b6\u6001\u7801");
                    }
                    CrcbHubResponseCode err = responseCodes[0];
                    throw new HelpIapException(UnifyErrorCode.TRANS_UNKNOW, err.getReturnCode(), err.getReturnMsg(), responseInfo);
                }
                return (T)responseInfo;
            }
            if (rspEntity.getStatusCodeValue() / 100 == 2) {
                this.logger.warn("\u63a5\u53e3[{}]\u8c03\u7528\u5931\u8d25,HttpState:[{}]", (Object)url, (Object)rspEntity.getStatusCode().value());
                throw new UnifyException(UnifyErrorCode.TRANS_UNKNOW, "HTTP\u670d\u52a1\u5668\u5185\u90e8\u901a\u8baf\u9519\u8bef:STATUS[" + rspEntity.getStatusCodeValue() + "]");
            }
            if (rspEntity.getStatusCodeValue() / 100 == 3 || rspEntity.getStatusCodeValue() / 100 == 4) {
                this.logger.warn("\u63a5\u53e3[{}]\u8c03\u7528\u5931\u8d25,HttpState:[{}]", (Object)url, (Object)rspEntity.getStatusCode().value());
                throw new UnifyException(UnifyErrorCode.NON_INTERFACE, "HTTP\u670d\u52a1\u5668\u5185\u90e8\u901a\u8baf\u9519\u8bef:STATUS[" + rspEntity.getStatusCodeValue() + "]");
            }
            this.logger.warn("\u63a5\u53e3[{}]\u8c03\u7528\u5931\u8d25,HttpState:[{}]", (Object)url, (Object)rspEntity.getStatusCode().value());
            throw new UnifyException(UnifyErrorCode.TRANS_UNKNOW, "HTTP\u670d\u52a1\u5668\u5185\u90e8\u901a\u8baf\u9519\u8bef,\u5bf9\u65b9\u670d\u52a1\u5668\u6267\u884c\u5931\u8d25");
        }
        this.logger.warn("\u63a5\u53e3[{}]\u8c03\u7528\u5931\u8d25,\u5bf9\u65b9\u65e0\u54cd\u5e94");
        throw new UnifyException(UnifyErrorCode.TRANS_UNKNOW, "HTTP\u670d\u52a1\u5668\u5185\u90e8\u901a\u8baf\u9519\u8bef,\u65e0\u6cd5\u83b7\u53d6\u54cd\u5e94\u4fe1\u606f");
    }
}

