/*
 * Decompiled with CFR 0.152.
 */
package com.help.aop;

import com.help.common.HelpIapMessageBuilder;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.constraint.ISerNoGenerator;
import com.help.crcb.hub.CrcbHubRequestInfo;
import com.help.crcb.hub.CrcbHubResponseInfo;
import com.help.exception.HelpHystrixBadRequestException;
import com.help.iap.HelpIapRequestInfo;
import com.help.iap.HelpIapResponseInfo;
import feign.RetryableException;
import java.util.concurrent.ExecutionException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.validation.BindException;

@Aspect
public class HttpIapInvokeExceptionGlobalAspect
implements Ordered {
    private Logger logger = LoggerFactory.getLogger(HttpIapInvokeExceptionGlobalAspect.class);
    HelpIapMessageBuilder helpIapMessageBuilder;
    ISerNoGenerator iSerNoGenerator;

    public HttpIapInvokeExceptionGlobalAspect(HelpIapMessageBuilder helpIapMessageBuilder, ISerNoGenerator iSerNoGenerator) {
        this.helpIapMessageBuilder = helpIapMessageBuilder;
        this.iSerNoGenerator = iSerNoGenerator;
    }

    @Around(value="(@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController) ) && execution(public com.help.iap.HelpIapResponseInfo *(..))")
    public Object executeOld(ProceedingJoinPoint pjp) throws Throwable {
        try {
            return pjp.proceed();
        }
        catch (Exception e) {
            CrcbHubResponseInfo responseInfo = this.handle(e, this.getRequest(pjp));
            HelpIapResponseInfo rsp = new HelpIapResponseInfo();
            rsp.setResponseHead(responseInfo.getResponseHead());
            return rsp;
        }
    }

    @Around(value="(@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController) ) && execution(public com.help.crcb.hub.CrcbHubResponseInfo *(..))")
    public Object execute(ProceedingJoinPoint pjp) throws Throwable {
        try {
            return pjp.proceed();
        }
        catch (Exception e) {
            return this.handle(e, this.getRequest(pjp));
        }
    }

    private CrcbHubResponseInfo handle(Throwable exp, CrcbHubRequestInfo requestInfo) {
        if (exp instanceof BindException) {
            CrcbHubResponseInfo responseInfo = this.helpIapMessageBuilder.buildHubResponse(requestInfo.getRequestHead());
            responseInfo.setError(UnifyErrorCode.VALIDATE_FAILD);
            if (this.iSerNoGenerator != null) {
                responseInfo.getResponseHead().setSplrSeqNo(this.iSerNoGenerator.getRandomSerno());
            }
            return responseInfo;
        }
        if (exp instanceof UnifyException) {
            UnifyException e = (UnifyException)exp;
            if (e.getErrorCode().getLevel() < 3) {
                this.logger.info("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:[" + e.getMessage() + "]", (Throwable)e);
            } else if (e.getErrorCode().getLevel() < 4) {
                this.logger.info("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:[" + e.getMessage() + "]", (Throwable)e);
            } else {
                this.logger.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:[" + e.getMessage() + "]", (Throwable)e);
            }
            CrcbHubResponseInfo responseInfo = this.helpIapMessageBuilder.buildHubResponse(requestInfo.getRequestHead());
            responseInfo.setError(e);
            if (this.iSerNoGenerator != null) {
                responseInfo.getResponseHead().setSplrSeqNo(this.iSerNoGenerator.getRandomSerno());
            }
            return responseInfo;
        }
        if (exp instanceof DuplicateKeyException) {
            DuplicateKeyException e = (DuplicateKeyException)exp;
            this.logger.warn("\u6570\u636e\u5e93\u4e3b\u952e\u51b2\u7a81\u5f02\u5e38:[" + e.getMessage() + "]", (Throwable)e);
            CrcbHubResponseInfo responseInfo = this.helpIapMessageBuilder.buildHubResponse(requestInfo.getRequestHead());
            responseInfo.setError(UnifyErrorCode.DATA_REPETITION, "\u8bf7\u52ff\u5f55\u5165\u91cd\u590d\u6570\u636e");
            if (this.iSerNoGenerator != null) {
                responseInfo.getResponseHead().setSplrSeqNo(this.iSerNoGenerator.getRandomSerno());
            }
            return responseInfo;
        }
        if (exp instanceof DataAccessException) {
            DataAccessException e = (DataAccessException)exp;
            this.logger.warn("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38:[" + e.getMessage() + "]", (Throwable)e);
            CrcbHubResponseInfo responseInfo = this.helpIapMessageBuilder.buildHubResponse(requestInfo.getRequestHead());
            responseInfo.setError(UnifyErrorCode.BUSINESS_FAILD, "\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
            if (this.iSerNoGenerator != null) {
                responseInfo.getResponseHead().setSplrSeqNo(this.iSerNoGenerator.getRandomSerno());
            }
            return responseInfo;
        }
        if (exp instanceof ExecutionException) {
            return this.handle(exp.getCause(), requestInfo);
        }
        if (exp instanceof HelpHystrixBadRequestException) {
            HelpHystrixBadRequestException exception = (HelpHystrixBadRequestException)exp;
            CrcbHubResponseInfo responseInfo = this.helpIapMessageBuilder.buildHubResponse(requestInfo.getRequestHead());
            responseInfo.setError(exception.getErrorCode(), exception.getMessage());
            if (this.iSerNoGenerator != null) {
                responseInfo.getResponseHead().setSplrSeqNo(this.iSerNoGenerator.getRandomSerno());
            }
            return responseInfo;
        }
        if (exp instanceof RetryableException) {
            this.logger.warn("\u670d\u52a1\u5668\u5185\u90e8\u901a\u4fe1\u5931\u8d25", exp);
            CrcbHubResponseInfo responseInfo = this.helpIapMessageBuilder.buildHubResponse(requestInfo.getRequestHead());
            responseInfo.setError(UnifyErrorCode.NETWORK_FAIL, "\u670d\u52a1\u5668\u5185\u90e8\u901a\u4fe1\u5931\u8d25");
            if (this.iSerNoGenerator != null) {
                responseInfo.getResponseHead().setSplrSeqNo(this.iSerNoGenerator.getRandomSerno());
            }
            return responseInfo;
        }
        this.logger.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25,\u672a\u77e5\u9519\u8bef:[" + exp.getMessage() + "]", exp);
        CrcbHubResponseInfo responseInfo = this.helpIapMessageBuilder.buildHubResponse(requestInfo.getRequestHead());
        responseInfo.setError(UnifyErrorCode.UNKNOW_FAIL);
        if (this.iSerNoGenerator != null) {
            responseInfo.getResponseHead().setSplrSeqNo(this.iSerNoGenerator.getRandomSerno());
        }
        return responseInfo;
    }

    private CrcbHubRequestInfo<Void> getRequest(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof HelpIapRequestInfo) {
                    CrcbHubRequestInfo requestInfo = new CrcbHubRequestInfo();
                    requestInfo.setRequestHead(((HelpIapRequestInfo)args[i]).getRequestHead());
                    return requestInfo;
                }
                if (!(args[i] instanceof CrcbHubRequestInfo)) continue;
                return (CrcbHubRequestInfo)args[i];
            }
        }
        return new CrcbHubRequestInfo();
    }

    public int getOrder() {
        return 10;
    }
}

