/*
 * Decompiled with CFR 0.152.
 */
package com.help.feign;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.BeanConvert;
import com.help.crcb.hub.CrcbHubResponseCode;
import com.help.crcb.hub.CrcbHubResponseHead;
import com.help.crcb.hub.CrcbHubResponseInfo;
import com.help.exception.HelpIapException;
import com.help.feign.IHelpFeignBusinessExceptionAnalysis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpIapFeignErrorAnalysis
implements IHelpFeignBusinessExceptionAnalysis {
    Logger logger = LoggerFactory.getLogger(HelpIapFeignErrorAnalysis.class);

    public boolean support(Object object) {
        return object instanceof CrcbHubResponseInfo;
    }

    public UnifyException analysis(Object object) {
        CrcbHubResponseInfo crcbHubResponseInfo = (CrcbHubResponseInfo)object;
        CrcbHubResponseHead responseHead = crcbHubResponseInfo.getResponseHead();
        if (responseHead == null) {
            return new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u670d\u52a1\u7aef\u672a\u54cd\u5e94\u6b63\u786e\u7684\u62a5\u6587\u5934");
        }
        if (!"S".equalsIgnoreCase(responseHead.getReturnStatus())) {
            this.logger.warn("HTTP\u901a\u8baf\u670d\u52a1\u7aef\u6267\u884c\u5f02\u5e38: {}", (Object)BeanConvert.toJson((Object)object));
            CrcbHubResponseCode[] responseCodes = responseHead.getRet();
            if (responseCodes == null || responseCodes.length == 0) {
                return new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u670d\u52a1\u7aef\u672a\u54cd\u5e94\u6b63\u786e\u7684\u72b6\u6001\u7801");
            }
            CrcbHubResponseCode err = responseCodes[0];
            return new HelpIapException(UnifyErrorCode.TRANS_UNKNOW, err.getReturnCode(), err.getReturnMsg(), crcbHubResponseInfo);
        }
        return null;
    }
}

