/*
 * Decompiled with CFR 0.152.
 */
package com.help.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.help.common.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.lang.Nullable;

public class ESBHttpMessageConverter
extends AbstractJackson2HttpMessageConverter {
    @Nullable
    private String jsonPrefix;
    @Autowired(required=false)
    HttpServletRequest request;

    public ESBHttpMessageConverter() {
        this(Jackson2ObjectMapperBuilder.json().build());
    }

    public ESBHttpMessageConverter(ObjectMapper objectMapper) {
        super(objectMapper);
        ArrayList<MediaType> typeList = new ArrayList<MediaType>();
        typeList.add(MediaType.APPLICATION_OCTET_STREAM);
        super.setSupportedMediaTypes(typeList);
    }

    protected boolean canWrite(@Nullable MediaType mediaType) {
        try {
            if (this.request != null && StringUtil.isNotEmpty((String)this.request.getContentType())) {
                try {
                    MediaType media = MediaType.valueOf((String)this.request.getContentType());
                    return MediaType.APPLICATION_OCTET_STREAM.isCompatibleWith(media);
                }
                catch (Exception media) {
                    // empty catch block
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setJsonPrefix(String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.jsonPrefix = prefixJson ? ")]}', " : null;
    }

    protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
        if (this.jsonPrefix != null) {
            generator.writeRaw(this.jsonPrefix);
        }
    }
}

