/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.help.common.HelpIapHttpClient;
import com.help.common.HelpIapMessageBuilder;
import com.help.config.HelpCrcbIapConfig;
import com.help.constraint.ISerNoGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class HelpCrcbIapAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ClientHttpRequestFactory.class})
    public SimpleClientHttpRequestFactory simpleClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setConnectTimeout(2000);
        factory.setReadTimeout(30000);
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean(value={RestTemplate.class})
    public RestTemplate restTemplate(ClientHttpRequestFactory factory) {
        RestTemplate restTemplate = new RestTemplate(factory);
        return restTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="help.iap")
    public HelpCrcbIapConfig helpCrcbIapConfig() {
        return new HelpCrcbIapConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    public HelpIapHttpClient helpIapHttpClient(HelpCrcbIapConfig helpCrcbIapConfig, RestTemplate restTemplate) {
        return new HelpIapHttpClient(helpCrcbIapConfig, restTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public HelpIapMessageBuilder helpIapMessageBuilder(HelpCrcbIapConfig helpCrcbIapConfig, @Autowired(required=false) ISerNoGenerator iSerNoGenerator) {
        return new HelpIapMessageBuilder(helpCrcbIapConfig, iSerNoGenerator);
    }
}

