/*
 * Decompiled with CFR 0.152.
 */
package com.help.common;

import com.help.common.util.Convert;
import com.help.config.HelpCrcbIapConfig;
import com.help.constraint.ISerNoGenerator;
import com.help.crcb.hub.CrcbHubRequestHead;
import com.help.crcb.hub.CrcbHubRequestInfo;
import com.help.crcb.hub.CrcbHubResponseHead;
import com.help.crcb.hub.CrcbHubResponseInfo;
import com.help.iap.HelpIapRequestInfo;
import com.help.iap.HelpIapResponseInfo;
import java.net.InetAddress;
import java.util.Date;

public class HelpIapMessageBuilder {
    private HelpCrcbIapConfig helpCrcbIapConfig;
    private ISerNoGenerator iSerNoGenerator;
    private String ip;

    public HelpIapMessageBuilder(HelpCrcbIapConfig helpCrcbIapConfig, ISerNoGenerator iSerNoGenerator) {
        this.helpCrcbIapConfig = helpCrcbIapConfig;
        this.iSerNoGenerator = iSerNoGenerator;
        try {
            this.ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deprecated
    public HelpIapRequestInfo buildRequest() {
        String serno = null;
        if (this.iSerNoGenerator != null) {
            serno = this.iSerNoGenerator.getRandomSerno();
        }
        return this.buildRequest(serno);
    }

    public <T> CrcbHubRequestInfo<T> buildHubRequest() {
        String serno = null;
        if (this.iSerNoGenerator != null) {
            serno = this.iSerNoGenerator.getRandomSerno();
        }
        return this.buildHubRequest(serno);
    }

    @Deprecated
    public HelpIapRequestInfo buildRequest(String serno) {
        HelpIapRequestInfo requestInfo = new HelpIapRequestInfo();
        CrcbHubRequestHead reqHead = requestInfo.getRequestHead();
        reqHead.setConsumerId(this.helpCrcbIapConfig.getSysId());
        reqHead.setOrgConsumerId(this.helpCrcbIapConfig.getSysId());
        reqHead.setConsumerSeqNo(serno);
        reqHead.setOrgConsumerSeqNo(serno);
        reqHead.setChannelTyp(this.helpCrcbIapConfig.getChannelTyp());
        reqHead.setConsumerSvrId(this.ip);
        reqHead.setOrgConsumerSvrId(this.ip);
        reqHead.setUserLang("CHINESE");
        Date date = new Date();
        reqHead.setTranDate(Convert.toString((Date)date, (String)"yyyyMMdd"));
        reqHead.setTranTime(Convert.toString((Date)date, (String)"HHmmss"));
        reqHead.setFilFlg("0");
        reqHead.setLegalRepCode("001");
        return requestInfo;
    }

    public <T> CrcbHubRequestInfo<T> buildHubRequest(String serno) {
        CrcbHubRequestInfo requestInfo = new CrcbHubRequestInfo();
        CrcbHubRequestHead reqHead = new CrcbHubRequestHead();
        requestInfo.setRequestHead(reqHead);
        reqHead.setConsumerId(this.helpCrcbIapConfig.getSysId());
        reqHead.setOrgConsumerId(this.helpCrcbIapConfig.getSysId());
        reqHead.setConsumerSeqNo(serno);
        reqHead.setOrgConsumerSeqNo(serno);
        reqHead.setChannelTyp(this.helpCrcbIapConfig.getChannelTyp());
        reqHead.setConsumerSvrId(this.ip);
        reqHead.setOrgConsumerSvrId(this.ip);
        reqHead.setUserLang("CHINESE");
        Date date = new Date();
        reqHead.setTranDate(Convert.toString((Date)date, (String)"yyyyMMdd"));
        reqHead.setTranTime(Convert.toString((Date)date, (String)"HHmmss"));
        reqHead.setFilFlg("0");
        reqHead.setLegalRepCode("001");
        return requestInfo;
    }

    @Deprecated
    public HelpIapResponseInfo buildResponse(HelpIapRequestInfo requestInfo) {
        String serno = null;
        if (this.iSerNoGenerator != null) {
            serno = this.iSerNoGenerator.getRandomSerno();
        }
        return this.buildResponse(requestInfo, serno);
    }

    @Deprecated
    public HelpIapResponseInfo buildResponse(HelpIapRequestInfo requestInfo, String serno) {
        if (requestInfo != null) {
            return this.buildResponse(requestInfo.getRequestHead(), serno);
        }
        return this.buildResponse((CrcbHubRequestHead)null, serno);
    }

    @Deprecated
    public HelpIapResponseInfo buildResponse(CrcbHubRequestHead requestHead) {
        String serno = null;
        if (this.iSerNoGenerator != null) {
            serno = this.iSerNoGenerator.getRandomSerno();
        }
        return this.buildResponse(requestHead, serno);
    }

    @Deprecated
    public HelpIapResponseInfo buildResponse(CrcbHubRequestHead requestHead, String serno) {
        HelpIapResponseInfo responseInfo = new HelpIapResponseInfo();
        CrcbHubResponseHead responseHead = responseInfo.getResponseHead();
        if (requestHead != null) {
            responseHead.setServiceCode(requestHead.getServiceCode());
            responseHead.setServiceScene(requestHead.getServiceScene());
            responseHead.setConsumerId(requestHead.getConsumerId());
            responseHead.setOrgConsumerId(requestHead.getOrgConsumerId());
            responseHead.setConsumerSeqNo(requestHead.getConsumerSeqNo());
            responseHead.setOrgConsumerSeqNo(requestHead.getOrgConsumerSeqNo());
            responseHead.setTerminalCode(requestHead.getTerminalCode());
            responseHead.setOrgTerminalCode(requestHead.getOrgTerminalCode());
            responseHead.setConsumerSvrId(requestHead.getConsumerSvrId());
            responseHead.setOrgConsumerSvrId(requestHead.getOrgConsumerSvrId());
            responseHead.setUserLang(requestHead.getUserLang());
        }
        responseHead.setSplrSeqNo(serno);
        responseHead.setDestSvrId(this.ip);
        responseHead.setTargetId(this.helpCrcbIapConfig.getSysId());
        responseHead.setFilFlg("0");
        Date date = new Date();
        responseHead.setTranDate(Convert.toString((Date)date, (String)"yyyyMMdd"));
        responseHead.setTranTime(Convert.toString((Date)date, (String)"HHmmss"));
        return responseInfo;
    }

    public <T> CrcbHubResponseInfo<T> buildHubResponse() {
        return this.buildHubResponse(new CrcbHubRequestHead(), null);
    }

    public <T> CrcbHubResponseInfo<T> buildHubResponse(String serno) {
        return this.buildHubResponse(new CrcbHubRequestHead(), serno);
    }

    public <T> CrcbHubResponseInfo<T> buildHubResponse(CrcbHubRequestInfo requestInfo) {
        return this.buildHubResponse(requestInfo.getRequestHead());
    }

    public <T> CrcbHubResponseInfo<T> buildHubResponse(CrcbHubRequestInfo requestInfo, String serno) {
        return this.buildHubResponse(requestInfo.getRequestHead(), serno);
    }

    public <T> CrcbHubResponseInfo<T> buildHubResponse(CrcbHubRequestHead requestHead) {
        String serno = null;
        if (this.iSerNoGenerator != null) {
            serno = this.iSerNoGenerator.getRandomSerno();
        }
        return this.buildHubResponse(requestHead, serno);
    }

    public <T> CrcbHubResponseInfo<T> buildHubResponse(CrcbHubRequestHead requestHead, String serno) {
        CrcbHubResponseInfo responseInfo = new CrcbHubResponseInfo();
        CrcbHubResponseHead responseHead = new CrcbHubResponseHead();
        responseInfo.setResponseHead(responseHead);
        if (requestHead != null) {
            responseHead.setServiceCode(requestHead.getServiceCode());
            responseHead.setServiceScene(requestHead.getServiceScene());
            responseHead.setConsumerId(requestHead.getConsumerId());
            responseHead.setOrgConsumerId(requestHead.getOrgConsumerId());
            responseHead.setConsumerSeqNo(requestHead.getConsumerSeqNo());
            responseHead.setOrgConsumerSeqNo(requestHead.getOrgConsumerSeqNo());
            responseHead.setTerminalCode(requestHead.getTerminalCode());
            responseHead.setOrgTerminalCode(requestHead.getOrgTerminalCode());
            responseHead.setConsumerSvrId(requestHead.getConsumerSvrId());
            responseHead.setOrgConsumerSvrId(requestHead.getOrgConsumerSvrId());
            responseHead.setUserLang(requestHead.getUserLang());
        }
        responseHead.setSplrSeqNo(serno);
        responseHead.setDestSvrId(this.ip);
        responseHead.setTargetId(this.helpCrcbIapConfig.getSysId());
        responseHead.setFilFlg("0");
        Date date = new Date();
        responseHead.setTranDate(Convert.toString((Date)date, (String)"yyyyMMdd"));
        responseHead.setTranTime(Convert.toString((Date)date, (String)"HHmmss"));
        return responseInfo;
    }
}

