/*
 * Decompiled with CFR 0.152.
 */
package com.help.common;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.StringUtil;
import com.help.config.HelpCrcbIapConfig;
import com.help.crcb.hub.CrcbHubRequestInfo;
import com.help.crcb.hub.CrcbHubResponseInfo;
import com.help.exception.HelpIapException;
import com.help.iap.HelpIapResponseInfo;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Deprecated
public class HelpIapHttpClient {
    Logger logger = LoggerFactory.getLogger(HelpIapHttpClient.class);
    private HelpCrcbIapConfig helpCrcbIapConfig;
    private RestTemplate restTemplate;

    public HelpIapHttpClient(HelpCrcbIapConfig helpCrcbIapConfig, RestTemplate restTemplate) {
        this.helpCrcbIapConfig = helpCrcbIapConfig;
        this.restTemplate = restTemplate;
    }

    public String buildUrl(String relativeUrl) {
        if (relativeUrl != null && (relativeUrl.toLowerCase().indexOf("http://") == 0 || relativeUrl.toLowerCase().indexOf("https://") == 0)) {
            return relativeUrl;
        }
        if (StringUtil.isNotEmpty((String)this.helpCrcbIapConfig.getGateway())) {
            if (relativeUrl.startsWith("/")) {
                relativeUrl = relativeUrl.substring(1);
            }
            if (this.helpCrcbIapConfig.getGateway().endsWith("/")) {
                return this.helpCrcbIapConfig.getGateway() + relativeUrl;
            }
            return this.helpCrcbIapConfig.getGateway() + "/" + relativeUrl;
        }
        throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u60a8\u5c1a\u672a\u914d\u7f6e[\u4e1a\u52a1\u67a2\u7ebd\u7f51\u5173\u5730\u5740]");
    }

    public HelpIapResponseInfo postGateway(String relativeUrl, CrcbHubRequestInfo request) {
        return this.postGateway(relativeUrl, request, new ParameterizedTypeReference<HelpIapResponseInfo>(){});
    }

    public <T extends CrcbHubResponseInfo> T postGateway(String relativeUrl, CrcbHubRequestInfo request, ParameterizedTypeReference<T> typeReference) {
        relativeUrl = this.buildUrl(relativeUrl);
        return this.post(relativeUrl, request, typeReference);
    }

    public HelpIapResponseInfo post(String url, CrcbHubRequestInfo request) {
        return this.post(url, request, new ParameterizedTypeReference<HelpIapResponseInfo>(){});
    }

    public <T extends CrcbHubResponseInfo> T post(String url, CrcbHubRequestInfo request, ParameterizedTypeReference<T> typeReference) {
        if (StringUtil.isEmpty((String)url) || url.indexOf("http://") != 0 && url.indexOf("https://") != 0) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u8bf7\u6c42URL\u5fc5\u987b\u4ee5http://\u6216https://\u5f00\u5934");
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        ArrayList<MediaType> jsonTypes = new ArrayList<MediaType>();
        jsonTypes.add(MediaType.APPLICATION_JSON);
        httpHeaders.setAccept(jsonTypes);
        HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)httpHeaders);
        ResponseEntity rspEntity = this.restTemplate.exchange(url, HttpMethod.POST, entity, typeReference, new Object[0]);
        if (StringUtil.isNotEmpty((Object)rspEntity)) {
            if (rspEntity.getStatusCode() == HttpStatus.OK) {
                CrcbHubResponseInfo responseInfo = (CrcbHubResponseInfo)rspEntity.getBody();
                if (!responseInfo.isSuccess()) {
                    throw new HelpIapException(responseInfo);
                }
                return (T)responseInfo;
            }
            this.logger.warn("\u63a5\u53e3[{}]\u8c03\u7528\u5931\u8d25,HttpState:[{}]", (Object)url, (Object)rspEntity.getStatusCode().value());
            throw new UnifyException(UnifyErrorCode.NETWORK_FAIL, "\u63a5\u53e3\u8c03\u7528\u5931\u8d25,HttpState:" + rspEntity.getStatusCode().value());
        }
        return null;
    }
}

