package com.help.exception;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.crcb.hub.CrcbHubResponseCode;
import com.help.crcb.hub.CrcbHubResponseInfo;

/**
 * 业务枢纽异常信息
 *
 * @author: YuBin-002726
 * @Date: 2019/5/23 15:04
 */
public class HelpIapException extends UnifyException {

    private CrcbHubResponseInfo responseInfo;

    private String message;

    public HelpIapException(CrcbHubResponseInfo responseInfo) {
        if (!"F".equalsIgnoreCase(responseInfo.getResponseHead().getReturnStatus())) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "业务枢纽并未发生异常");
        }
        this.responseInfo = responseInfo;
        CrcbHubResponseCode[] responseCode = responseInfo.getResponseHead().getRet();
        if (responseCode != null && responseCode.length > 0) {
            this.message = "业务枢纽网关调用异常:" + responseCode[0].getReturnCode() + "[" + responseCode[0].getReturnMsg() + "]";
        }
    }

    public CrcbHubResponseInfo getResponseInfo() {
        return responseInfo;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}
