package com.help.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.lang.Nullable;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * @author: YuBin-002726
 * @Date: 2019/9/2 16:11
 */
public class ESBHttpMessageConverter extends MappingJackson2HttpMessageConverter {

    public ESBHttpMessageConverter() {
        super(Jackson2ObjectMapperBuilder.json().build());

        List<MediaType> typeList = new ArrayList<>();
        typeList.add(MediaType.APPLICATION_OCTET_STREAM);

        super.setSupportedMediaTypes(typeList);
    }

    @Autowired(required = false)
    HttpServletRequest request;

    @Override
    protected boolean canWrite(@Nullable MediaType mediaType) {
        try {
            if (request != null && MediaType.APPLICATION_OCTET_STREAM.isCompatibleWith(MediaType.valueOf(request.getContentType()))) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            return false;
        }
    }

}
