package com.help.common;

import com.help.common.util.Convert;
import com.help.config.HelpCrcbIapConfig;
import com.help.constraint.ISerNoGenerator;
import com.help.crcb.hub.CrcbHubRequestHead;
import com.help.crcb.hub.CrcbHubRequestInfo;
import com.help.crcb.hub.CrcbHubResponseHead;
import com.help.crcb.hub.CrcbHubResponseInfo;
import com.help.iap.HelpIapRequestInfo;
import com.help.iap.HelpIapResponseInfo;

import java.net.InetAddress;
import java.util.Date;

/**
 * 业务枢纽报文构造器
 *
 * @author: YuBin-002726
 * @Date: 2019/5/22 16:18
 */
public class HelpIapMessageBuilder {

    private HelpCrcbIapConfig helpCrcbIapConfig;
    private ISerNoGenerator iSerNoGenerator;

    private String ip;

    public HelpIapMessageBuilder(HelpCrcbIapConfig helpCrcbIapConfig, ISerNoGenerator iSerNoGenerator) {
        this.helpCrcbIapConfig = helpCrcbIapConfig;
        this.iSerNoGenerator = iSerNoGenerator;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        } catch (Exception e) {

        }
    }

    /**
     * 构造一个带有随机流水号的基础请求信息
     * 不带有serviceCode,serviceScene,tranCode
     *
     * @return
     * @see #buildHubRequest() 业务枢纽将使用新请求结构
     */
    @Deprecated
    public HelpIapRequestInfo buildRequest() {
        String serno = null;
        if (iSerNoGenerator != null) {
            serno = iSerNoGenerator.getRandomSerno();
        }
        return buildRequest(serno);
    }

    /**
     * 构造一个带有随机流水号的基础请求信息
     * 不带有serviceCode,serviceScene,tranCode
     *
     * @return
     */
    public <T> CrcbHubRequestInfo<T> buildHubRequest() {
        String serno = null;
        if (iSerNoGenerator != null) {
            serno = iSerNoGenerator.getRandomSerno();
        }
        return buildHubRequest(serno);
    }

    /**
     * 构造一个带有随机流水号的基础请求头
     * 不带有serviceCode,serviceScene,tranCode
     *
     * @return
     * @see #buildHubRequest(String) 业务枢纽将使用新请求结构
     */
    @Deprecated
    public HelpIapRequestInfo buildRequest(String serno) {
        HelpIapRequestInfo requestInfo = new HelpIapRequestInfo();

        CrcbHubRequestHead reqHead = requestInfo.getRequestHead();

        reqHead.setConsumerId(helpCrcbIapConfig.getSysId());
        reqHead.setOrgConsumerId(helpCrcbIapConfig.getSysId());
        reqHead.setConsumerSeqNo(serno);
        reqHead.setOrgConsumerSeqNo(serno);

        reqHead.setChannelTyp(helpCrcbIapConfig.getChannelTyp());

        reqHead.setConsumerSvrId(ip);
        reqHead.setOrgConsumerSvrId(ip);

        reqHead.setUserLang("CHINESE");

        Date date = new Date();
        reqHead.setTranDate(Convert.toString(date, "yyyyMMdd"));
        reqHead.setTranTime(Convert.toString(date, "HHmmss"));

        reqHead.setFilFlg("0");
        reqHead.setLegalRepCode("001");

        return requestInfo;
    }

    /**
     * 构造一个带有随机流水号的基础请求头
     * 不带有serviceCode,serviceScene,tranCode
     *
     * @return
     */
    public <T> CrcbHubRequestInfo<T> buildHubRequest(String serno) {
        CrcbHubRequestInfo requestInfo = new CrcbHubRequestInfo();

        CrcbHubRequestHead reqHead = new CrcbHubRequestHead();

        requestInfo.setRequestHead(reqHead);

        reqHead.setConsumerId(helpCrcbIapConfig.getSysId());
        reqHead.setOrgConsumerId(helpCrcbIapConfig.getSysId());
        reqHead.setConsumerSeqNo(serno);
        reqHead.setOrgConsumerSeqNo(serno);

        reqHead.setChannelTyp(helpCrcbIapConfig.getChannelTyp());

        reqHead.setConsumerSvrId(ip);
        reqHead.setOrgConsumerSvrId(ip);

        reqHead.setUserLang("CHINESE");

        Date date = new Date();
        reqHead.setTranDate(Convert.toString(date, "yyyyMMdd"));
        reqHead.setTranTime(Convert.toString(date, "HHmmss"));

        reqHead.setFilFlg("0");
        reqHead.setLegalRepCode("001");

        return requestInfo;
    }

    /**
     * 使用请求信息构建一个成功响应信息
     * 该构建器会按照枢纽开发规范构建响应,并设置为响应成功,将随机生成服务方系统流水号splrSeqNo
     *
     * @param requestInfo
     * @return
     * @see #buildHubResponse(CrcbHubRequestHead)
     */
    @Deprecated
    public HelpIapResponseInfo buildResponse(HelpIapRequestInfo requestInfo) {
        String serno = null;
        if (iSerNoGenerator != null) {
            serno = iSerNoGenerator.getRandomSerno();
        }
        return buildResponse(requestInfo, serno);
    }

    /**
     * 使用请求信息和指定的服务方响应流水号构建一个成功响应信息
     *
     * @param requestInfo
     * @param serno
     * @return
     * @see #buildHubResponse(CrcbHubRequestHead, String)
     */
    @Deprecated
    public HelpIapResponseInfo buildResponse(HelpIapRequestInfo requestInfo, String serno) {
        if (requestInfo != null) {
            return buildResponse(requestInfo.getRequestHead(), serno);
        } else {
            return buildResponse((CrcbHubRequestHead) null, serno);
        }
    }

    @Deprecated
    public HelpIapResponseInfo buildResponse(CrcbHubRequestHead requestHead) {
        String serno = null;
        if (iSerNoGenerator != null) {
            serno = iSerNoGenerator.getRandomSerno();
        }
        return buildResponse(requestHead, serno);
    }

    /**
     * 使用请求信息和指定的服务方响应流水号构建一个成功响应信息
     *
     * @param requestHead
     * @param serno
     * @return
     * @see #buildHubResponse(CrcbHubRequestHead, String)
     */
    @Deprecated
    public HelpIapResponseInfo buildResponse(CrcbHubRequestHead requestHead, String serno) {
        HelpIapResponseInfo responseInfo = new HelpIapResponseInfo();
        CrcbHubResponseHead responseHead = responseInfo.getResponseHead();

        if (requestHead != null) {

            responseHead.setServiceCode(requestHead.getServiceCode());
            responseHead.setServiceScene(requestHead.getServiceScene());
            responseHead.setConsumerId(requestHead.getConsumerId());
            responseHead.setOrgConsumerId(requestHead.getOrgConsumerId());
            responseHead.setConsumerSeqNo(requestHead.getConsumerSeqNo());
            responseHead.setOrgConsumerSeqNo(requestHead.getOrgConsumerSeqNo());
            responseHead.setTerminalCode(requestHead.getTerminalCode());
            responseHead.setOrgTerminalCode(requestHead.getOrgTerminalCode());
            responseHead.setConsumerSvrId(requestHead.getConsumerSvrId());
            responseHead.setOrgConsumerSvrId(requestHead.getOrgConsumerSvrId());
            responseHead.setUserLang(requestHead.getUserLang());
        }

        responseHead.setSplrSeqNo(serno);

        responseHead.setDestSvrId(ip);
        responseHead.setTargetId(helpCrcbIapConfig.getSysId());

        responseHead.setFilFlg("0");

        Date date = new Date();
        responseHead.setTranDate(Convert.toString(date, "yyyyMMdd"));
        responseHead.setTranTime(Convert.toString(date, "HHmmss"));

        return responseInfo;
    }

    /**
     * 构建一个成功响应信息
     * 该构建器会按照枢纽开发规范构建响应,并设置为响应成功,将随机生成服务方系统流水号splrSeqNo
     *
     * @return
     */
    public <T> CrcbHubResponseInfo<T> buildHubResponse() {
        return buildHubResponse(new CrcbHubRequestHead(), null);
    }

    /**
     * 使用指定响应流水号构建一个成功响应信息
     * 该构建器会按照枢纽开发规范构建响应,并设置为响应成功
     *
     * @param serno 流水号
     * @return
     */
    public <T> CrcbHubResponseInfo<T> buildHubResponse(String serno) {
        return buildHubResponse(new CrcbHubRequestHead(), serno);
    }

    /**
     * 使用请求信息构建一个成功响应信息
     * 该构建器会按照枢纽开发规范构建响应,并设置为响应成功,将随机生成服务方系统流水号splrSeqNo
     *
     * @param requestInfo 请求头
     * @return
     */
    public <T> CrcbHubResponseInfo<T> buildHubResponse(CrcbHubRequestInfo requestInfo) {
        return buildHubResponse(requestInfo.getRequestHead());
    }

    /**
     * 使用请求信息和指定的服务方响应流水号构建一个成功响应信息
     *
     * @param requestInfo
     * @param serno
     * @return
     */
    public <T> CrcbHubResponseInfo<T> buildHubResponse(CrcbHubRequestInfo requestInfo, String serno) {
        return buildHubResponse(requestInfo.getRequestHead(), serno);
    }

    /**
     * 使用请求信息构建一个成功响应信息
     * 该构建器会按照枢纽开发规范构建响应,并设置为响应成功,将随机生成服务方系统流水号splrSeqNo
     *
     * @param requestHead 请求头
     * @return
     */
    public <T> CrcbHubResponseInfo<T> buildHubResponse(CrcbHubRequestHead requestHead) {
        String serno = null;
        if (iSerNoGenerator != null) {
            serno = iSerNoGenerator.getRandomSerno();
        }
        return buildHubResponse(requestHead, serno);
    }

    /**
     * 使用请求信息和指定的服务方响应流水号构建一个成功响应信息
     *
     * @param requestHead
     * @param serno
     * @return
     */
    public <T> CrcbHubResponseInfo<T> buildHubResponse(CrcbHubRequestHead requestHead, String serno) {
        CrcbHubResponseInfo responseInfo = new CrcbHubResponseInfo();
        CrcbHubResponseHead responseHead = new CrcbHubResponseHead();
        responseInfo.setResponseHead(responseHead);

        if (requestHead != null) {

            responseHead.setServiceCode(requestHead.getServiceCode());
            responseHead.setServiceScene(requestHead.getServiceScene());
            responseHead.setConsumerId(requestHead.getConsumerId());
            responseHead.setOrgConsumerId(requestHead.getOrgConsumerId());
            responseHead.setConsumerSeqNo(requestHead.getConsumerSeqNo());
            responseHead.setOrgConsumerSeqNo(requestHead.getOrgConsumerSeqNo());
            responseHead.setTerminalCode(requestHead.getTerminalCode());
            responseHead.setOrgTerminalCode(requestHead.getOrgTerminalCode());
            responseHead.setConsumerSvrId(requestHead.getConsumerSvrId());
            responseHead.setOrgConsumerSvrId(requestHead.getOrgConsumerSvrId());
            responseHead.setUserLang(requestHead.getUserLang());
        }

        responseHead.setSplrSeqNo(serno);

        responseHead.setDestSvrId(ip);
        responseHead.setTargetId(helpCrcbIapConfig.getSysId());

        responseHead.setFilFlg("0");

        Date date = new Date();
        responseHead.setTranDate(Convert.toString(date, "yyyyMMdd"));
        responseHead.setTranTime(Convert.toString(date, "HHmmss"));

        return responseInfo;
    }

}
