package com.help.common;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.StringUtil;
import com.help.config.HelpCrcbIapConfig;
import com.help.crcb.hub.CrcbHubRequestInfo;
import com.help.crcb.hub.CrcbHubResponseInfo;
import com.help.exception.HelpIapException;
import com.help.iap.HelpIapResponseInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.List;

/**
 * HELP平台业务枢纽连接工具
 *
 * @author: YuBin-002726
 * @Date: 2019/5/23 14:38
 * @see RestTemplate 建议直接使用RestTemplate组件或Feign
 */
@Deprecated
public class HelpIapHttpClient {

    Logger logger = LoggerFactory.getLogger(HelpIapHttpClient.class);

    private HelpCrcbIapConfig helpCrcbIapConfig;

    private RestTemplate restTemplate;

    public HelpIapHttpClient(HelpCrcbIapConfig helpCrcbIapConfig, RestTemplate restTemplate) {
        this.helpCrcbIapConfig = helpCrcbIapConfig;
        this.restTemplate = restTemplate;
    }

    /**
     * 通过相对路径构建指向业务枢纽网关的绝对路径
     *
     * @param relativeUrl
     * @return
     */
    public String buildUrl(String relativeUrl) {
        if (relativeUrl != null && (relativeUrl.toLowerCase().indexOf("http://") == 0 || relativeUrl.toLowerCase().indexOf("https://") == 0)) {
            return relativeUrl;
        }
        if (StringUtil.isNotEmpty(helpCrcbIapConfig.getGateway())) {
            if (relativeUrl.startsWith("/")) {
                relativeUrl = relativeUrl.substring(1);
            }
            if (helpCrcbIapConfig.getGateway().endsWith("/")) {
                return helpCrcbIapConfig.getGateway() + relativeUrl;
            } else {
                return helpCrcbIapConfig.getGateway() + "/" + relativeUrl;
            }
        } else {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "您尚未配置[业务枢纽网关地址]");
        }
    }

    /**
     * 向业务枢纽默认网关发送post请求
     *
     * @param relativeUrl
     * @param request
     * @return
     */
    public HelpIapResponseInfo postGateway(String relativeUrl, CrcbHubRequestInfo request) {
        return postGateway(relativeUrl, request, new ParameterizedTypeReference<HelpIapResponseInfo>() {
        });
    }

    /**
     * 向业务枢纽默认网关发送post请求
     *
     * @param relativeUrl
     * @param request
     * @param typeReference 返回的数据类型 例:new ParameterizedTypeReference<HelpIapResponseInfo>() {})
     * @param <T>           返回的数据类型
     * @return
     */
    public <T extends CrcbHubResponseInfo> T postGateway(String relativeUrl, CrcbHubRequestInfo request, ParameterizedTypeReference<T> typeReference) {

        relativeUrl = buildUrl(relativeUrl);

        return post(relativeUrl, request, typeReference);
    }

    /**
     * 向特定服务器发送post请求
     *
     * @param url
     * @param request
     * @return
     */
    public HelpIapResponseInfo post(String url, CrcbHubRequestInfo request) {
        return post(url, request, new ParameterizedTypeReference<HelpIapResponseInfo>() {
        });
    }

    /**
     * 向特定服务器发送post请求
     *
     * @param url
     * @param request
     * @param typeReference 返回的数据类型 例:new ParameterizedTypeReference<HelpIapResponseInfo>() {})
     * @param <T>           返回的数据类型
     * @return
     */
    public <T extends CrcbHubResponseInfo> T post(String url, CrcbHubRequestInfo request, ParameterizedTypeReference<T> typeReference) {

        if (StringUtil.isEmpty(url) || url.indexOf("http://") != 0 && url.indexOf("https://") != 0) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "请求URL必须以http://或https://开头");
        }

        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        List<MediaType> jsonTypes = new ArrayList<>();
        jsonTypes.add(MediaType.APPLICATION_JSON);
        httpHeaders.setAccept(jsonTypes);

        HttpEntity<CrcbHubRequestInfo> entity = new HttpEntity<>(request,httpHeaders);

        ResponseEntity<T> rspEntity = restTemplate.exchange(url, HttpMethod.POST, entity, typeReference);

        if (StringUtil.isNotEmpty(rspEntity)) {
            if (rspEntity.getStatusCode() == HttpStatus.OK) {
                T responseInfo = rspEntity.getBody();
                if (!responseInfo.isSuccess()) {
                    throw new HelpIapException(responseInfo);
                } else {
                    return responseInfo;
                }
            } else {
                logger.warn("接口[{}]调用失败,HttpState:[{}]", url, rspEntity.getStatusCode().value());
                throw new UnifyException(UnifyErrorCode.NETWORK_FAIL, "接口调用失败,HttpState:" + rspEntity.getStatusCode().value());
            }
        } else {
            return null;
        }
    }

}
