package com.help.autoconfig;

import com.help.aop.HttpIapInvokeExceptionGlobalAspect;
import com.help.aop.HttpIapInvokeValidateAspect;
import com.help.common.HelpIapMessageBuilder;
import com.help.conditional.ConditionalOnMatchOrEmpty;
import com.help.constraint.ISerNoGenerator;
import com.help.converter.ESBHttpMessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;

/**
 * @author: YuBin-002726
 * @Date: 2019/5/23 12:41
 */
@ConditionalOnWebApplication
public class HelpCrcbIapWebAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public HttpIapInvokeExceptionGlobalAspect httpIapInvokeExceptionGlobalAspect(@Autowired HelpIapMessageBuilder helpIapMessageBuilder, @Autowired(required = false) ISerNoGenerator iSerNoGenerator) {
        return new HttpIapInvokeExceptionGlobalAspect(helpIapMessageBuilder, iSerNoGenerator);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMatchOrEmpty(value = "help.validate.enable", havingValue = "true")
    public HttpIapInvokeValidateAspect httpIapInvokeValidateAspect() {
        return new HttpIapInvokeValidateAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    public ESBHttpMessageConverter esbHttpMessageConverter() {
        return new ESBHttpMessageConverter();
    }


}
