package com.help.autoconfig;

import com.help.aop.FeignInvokeExceptionAspect;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.context.annotation.Bean;

/**
 * @author: YuBin-002726
 * @Date: 2019/5/23 12:41
 */
@ConditionalOnClass({FeignClient.class, FeignContext.class})
@AutoConfigureAfter(FeignAutoConfiguration.class)
@ConditionalOnBean({FeignContext.class})
public class HelpCrcbIapOpenFeignAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public FeignInvokeExceptionAspect feignInvokeExceptionAspect() {
        return new FeignInvokeExceptionAspect();
    }
}
