package com.help.aop;

import com.help.common.annotation.ParamValid;
import com.help.common.exception.UnifyValidateException;
import com.help.common.util.StringUtil;
import com.help.validator.HelpValidator;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.web.bind.annotation.*;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;

/**
 * 请求参数的有效性验证
 *
 * @author JBF-YB
 */
@Aspect
public class HttpIapInvokeValidateAspect implements Ordered {

    @Autowired
    HelpValidator helpValidator;

    //切入所有返回InvocationResult或ModelAndView的方法做数据校验
    @Around("(@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController) ) && execution(public com.help.crcb.hub.CrcbHubResponseInfo+ *(..))")
    public Object execute(ProceedingJoinPoint pjp) throws Throwable {
        // 代理对象
        //String target = pjp.getSignature().getDeclaringTypeName();
        //代理方法
        Method method = ((MethodSignature) pjp.getSignature()).getMethod();
        //代理参数
        Annotation[][] annos = method.getParameterAnnotations();
        if (annos.length > 0) {
            Object[] args = pjp.getArgs();
            for (int i = 0; i < args.length; i++) {
                Annotation[] ans = annos[i];
                for (Annotation a : ans) {
                    if (a instanceof ParamValid) {
                        if (StringUtil.isEmpty(args[i])) {
                            Parameter p = method.getParameters()[i];
                            Map<String, String> param = new HashMap<>();
                            param.put(p.getName(), "请求参数[" + p.getName() + "]不可为空");
                            throw new UnifyValidateException(param);
                        }
                        helpValidator.validateForException(args[i]);
                    } else if (a instanceof RequestHeader && ((RequestHeader) a).required() && StringUtil.isEmpty(args[i])) {
                        Parameter p = method.getParameters()[i];
                        Map<String, String> param = new HashMap<>();
                        param.put(p.getName(), "请求参数[" + p.getName() + "]不可为空");
                        throw new UnifyValidateException(param);
                    } else if (a instanceof PathVariable && ((PathVariable) a).required() && StringUtil.isEmpty(args[i])) {
                        Parameter p = method.getParameters()[i];
                        Map<String, String> param = new HashMap<>();
                        param.put(p.getName(), "请求参数[" + p.getName() + "]不可为空");
                        throw new UnifyValidateException(param);
                    } else if (a instanceof CookieValue && ((CookieValue) a).required() && StringUtil.isEmpty(args[i])) {
                        Parameter p = method.getParameters()[i];
                        Map<String, String> param = new HashMap<>();
                        param.put(p.getName(), "请求参数[" + p.getName() + "]不可为空");
                        throw new UnifyValidateException(param);
                    } else if (a instanceof SessionAttribute && ((SessionAttribute) a).required() && StringUtil.isEmpty(args[i])) {
                        Parameter p = method.getParameters()[i];
                        Map<String, String> param = new HashMap<>();
                        param.put(p.getName(), "请求参数[" + p.getName() + "]不可为空");
                        throw new UnifyValidateException(param);
                    }
                }
            }
        }

        Object result = pjp.proceed();

        return result;
    }

    @Override
    public int getOrder() {
        return 50;
    }
}
