package com.help.aop;

import com.help.crcb.hub.CrcbHubResponseInfo;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.Ordered;

/**
 * @author: YuBin-002726
 * @Date: 2019/8/26 15:45
 */
@Aspect
public class FeignInvokeExceptionAspect implements Ordered {

    @AfterReturning(pointcut = "@within(org.springframework.cloud.openfeign.FeignClient) && execution(public com.help.crcb.hub.CrcbHubResponseInfo+ *(..))", returning = "returnVal")
    public void afterReturn(CrcbHubResponseInfo returnVal) {
        if (returnVal != null) {
            CrcbHubResponseInfo result = returnVal;

            result.checkError();
        }
    }

    @Override
    public int getOrder() {
        return 110;
    }

}
