/*
 * Decompiled with CFR 0.152.
 */
package com.help.crcb.hub;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.crcb.hub.CrcbHubResponseCode;
import com.help.crcb.hub.CrcbHubResponseHead;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CrcbHubResponseInfo<T> {
    private CrcbHubResponseHead responseHead;
    private T responseBody;

    @JsonIgnore
    public void setSuccess() {
        CrcbHubResponseHead responseHead = this.getResponseHead();
        if (responseHead == null) {
            responseHead = new CrcbHubResponseHead();
            this.setResponseHead(responseHead);
        }
        responseHead.setReturnStatus("S");
        CrcbHubResponseCode code = new CrcbHubResponseCode();
        code.setReturnCode("000000");
        code.setReturnMsg("\u4ea4\u6613\u6210\u529f");
        responseHead.setRet(new CrcbHubResponseCode[]{code});
    }

    @JsonIgnore
    public void setError(UnifyErrorCode error) {
        this.setError(error.getCode(), error.getMsg());
    }

    @JsonIgnore
    public void setError(UnifyErrorCode error, String message) {
        this.setError(error.getCode(), message);
    }

    @JsonIgnore
    public void setError(UnifyException exption) {
        this.setError(exption.getCustomState(), exption.getMessage());
    }

    @JsonIgnore
    public void setError(String errCode, String mesage) {
        CrcbHubResponseHead responseHead = this.getResponseHead();
        if (responseHead == null) {
            responseHead = new CrcbHubResponseHead();
            this.setResponseHead(responseHead);
        }
        responseHead.setReturnStatus("F");
        CrcbHubResponseCode code = new CrcbHubResponseCode();
        code.setReturnCode(errCode);
        code.setReturnMsg(mesage);
        responseHead.setRet(new CrcbHubResponseCode[]{code});
    }

    @JsonIgnore
    public void checkError() throws UnifyException {
        CrcbHubResponseHead responseHead = this.getResponseHead();
        if (responseHead == null) {
            throw new UnifyException(UnifyErrorCode.NON_DATA, "\u670d\u52a1\u7aef\u672a\u54cd\u5e94\u6b63\u786e\u7684\u62a5\u6587\u5934");
        }
        if (!"S".equalsIgnoreCase(responseHead.getReturnStatus())) {
            CrcbHubResponseCode[] responseCodes = responseHead.getRet();
            if (responseCodes == null || responseCodes.length == 0) {
                throw new UnifyException(UnifyErrorCode.NON_DATA, "\u670d\u52a1\u7aef\u672a\u54cd\u5e94\u6b63\u786e\u7684\u72b6\u6001\u7801");
            }
            CrcbHubResponseCode err = responseCodes[0];
            throw new UnifyException(err.getReturnCode(), "\u670d\u52a1\u7aef\u54cd\u5e94 \u9519\u8bef\u7801[" + err.getReturnCode() + "] " + err.getReturnMsg());
        }
    }

    @JsonIgnore
    public boolean isSuccess() {
        CrcbHubResponseHead responseHead = this.getResponseHead();
        return responseHead != null && "S".equalsIgnoreCase(this.getResponseHead().getReturnStatus());
    }

    public CrcbHubResponseHead getResponseHead() {
        return this.responseHead;
    }

    public void setResponseHead(CrcbHubResponseHead responseHead) {
        this.responseHead = responseHead;
    }

    public T getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(T responseBody) {
        this.responseBody = responseBody;
    }
}

