package com.help.iap;

import com.fasterxml.jackson.core.type.TypeReference;
import com.help.common.util.BeanConvert;
import com.help.crcb.hub.CrcbHubRequestHead;
import com.help.crcb.hub.CrcbHubRequestInfo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * HELP平台业务枢纽请求信息
 *
 * @author: YuBin-002726
 * @Date: 2019/5/17 16:09
 * @see com.help.crcb.hub.CrcbHubRequestInfo 建议直接使用该类型实现Springboot请求映射
 */
@Deprecated
public class HelpIapRequestInfo extends CrcbHubRequestInfo<Void> implements Map<String, Object> {

    private static final String REQUEST_HEADER_KEY = "requestHead";

    public HelpIapRequestInfo() {
        this.data.put(REQUEST_HEADER_KEY, new CrcbHubRequestHead());
    }

    /**
     * 获取请求头
     * 该方法不会返回null
     *
     * @return
     */
    @Override
    public CrcbHubRequestHead getRequestHead() {
        CrcbHubRequestHead header = (CrcbHubRequestHead) data.get(REQUEST_HEADER_KEY);
        if (header != null) {
            return header;
        } else {
            CrcbHubRequestHead head = new CrcbHubRequestHead();
            data.put(REQUEST_HEADER_KEY, head);
            return head;
        }
    }

    @Override
    public void setRequestHead(CrcbHubRequestHead head) {
        this.put(REQUEST_HEADER_KEY, head);
    }

    /**
     * @return
     * @see CrcbHubRequestInfo#getRequestBody()
     */
    @Override
    public Void getRequestBody() {
        throw new UnsupportedOperationException("枢纽系统老报文结构不支持此操作");
    }

    /**
     * @param requestBody
     * @see CrcbHubRequestInfo#setRequestBody(Object)
     */
    @Override
    public void setRequestBody(Void requestBody) {
        throw new UnsupportedOperationException("枢纽系统老报文结构不支持此操作");
    }

    private CrcbHubRequestHead transHeader(Object value) {
        if (value == null) {
            return new CrcbHubRequestHead();
        } else if (value instanceof CrcbHubRequestHead) {
            return (CrcbHubRequestHead) value;
        } else {
            return BeanConvert.fromMap(BeanConvert.toMap(value), CrcbHubRequestHead.class);
        }
    }

    /**
     * 获取请求信息
     * 请求头会被自动转换为HelpIapRequestHead
     *
     * @param key
     * @return
     */
    @Override
    public Object get(Object key) {
        if (REQUEST_HEADER_KEY.equals(key)) {
            return getRequestHead();
        } else {
            return data.get(key);
        }
    }


    /**
     * 设置请求信息
     * 请求头会被自动转换为HelpIapRequestHead
     *
     * @param key   字段
     * @param value 值
     * @return
     */
    @Override
    public Object put(String key, Object value) {
        if (REQUEST_HEADER_KEY.equals(key)) {
            return data.put(key, transHeader(value));
        } else {
            return data.put(key, value);
        }
    }

    /**
     * 批量设置请求信息
     * 请求头会被自动转换为HelpIapRequestHead
     *
     * @param m 响应信息Map
     */
    @Override
    public void putAll(Map m) {
        Object header = m.get(REQUEST_HEADER_KEY);
        if (header != null) {
            m.put(REQUEST_HEADER_KEY, transHeader(header));
        }
        data.putAll(m);
    }


    protected Map<String, Object> data = new HashMap<>();

    /**
     * 取值并转换为指定的类型(不支持泛型)
     *
     * @param key
     * @param clazz
     * @param <T>
     * @return
     * @see #get(String, TypeReference) 若需转换泛型,参考此方法
     */
    public <T> T get(String key, Class<T> clazz) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        } else {
            String json = BeanConvert.toJson(obj);
            return BeanConvert.fromJson(json, clazz);
        }
    }

    /**
     * 取值并转换为指定泛型类型
     *
     * @param key
     * @param typeReference 要转换为的泛型类型,例:new TypeReference<List<Student>>{}
     * @param <T>
     * @return
     * @see #get(String, Class) 若无需转换泛型推荐使用此方法
     */
    public <T> T get(String key, TypeReference<T> typeReference) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        } else {
            String json = BeanConvert.toJson(obj);
            return BeanConvert.fromJson(json, typeReference);
        }
    }

    @Override
    public int size() {
        return data.size();
    }

    @Override
    public boolean isEmpty() {
        return data.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return data.containsValue(value);
    }

    @Override
    public Object remove(Object key) {
        return data.remove(key);
    }

    @Override
    public void clear() {
        data.clear();
    }

    @Override
    public Set<String> keySet() {
        return data.keySet();
    }

    @Override
    public Collection<Object> values() {
        return data.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return data.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return data.equals(o);
    }

    @Override
    public int hashCode() {
        return data.hashCode();
    }

}
