package com.help.iap;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.help.common.validate.Length;

/**
 * 业务枢纽授信柜员信息
 * @author: YuBin-002726
 * @Date: 2019/5/17 16:43
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AuthTellerInfo {

    //授权柜员标识
    @Length(max = 10)
    private String authTellerNo;

    //授权机构代码
    @Length(max = 30)
    private String authBranchId;

    //授权柜员密码
    @Length(max = 30)
    private String authTellerPassword;

    //授权柜员级别
    @Length(max = 10)
    private String authTellerLevel;

    //授权柜员类别
    @Length(max = 10)
    private String authTellerType;

    public String getAuthTellerNo() {
        return authTellerNo;
    }

    public void setAuthTellerNo(String authTellerNo) {
        this.authTellerNo = authTellerNo;
    }

    public String getAuthBranchId() {
        return authBranchId;
    }

    public void setAuthBranchId(String authBranchId) {
        this.authBranchId = authBranchId;
    }

    public String getAuthTellerPassword() {
        return authTellerPassword;
    }

    public void setAuthTellerPassword(String authTellerPassword) {
        this.authTellerPassword = authTellerPassword;
    }

    public String getAuthTellerLevel() {
        return authTellerLevel;
    }

    public void setAuthTellerLevel(String authTellerLevel) {
        this.authTellerLevel = authTellerLevel;
    }

    public String getAuthTellerType() {
        return authTellerType;
    }

    public void setAuthTellerType(String authTellerType) {
        this.authTellerType = authTellerType;
    }
}
