package com.help.crcb.hub;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;

/**
 * HELP平台业务枢纽响应报文信息
 *
 * @author: YuBin-002726
 * @Date: 2019/7/25 16:41
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CrcbHubResponseInfo<T> {

    private CrcbHubResponseHead responseHead;

    private T responseBody;

    /**
     * 设置响应状态为成功
     */
    @JsonIgnore
    public void setSuccess() {
        CrcbHubResponseHead responseHead = this.getResponseHead();
        if (responseHead == null) {
            responseHead = new CrcbHubResponseHead();
            this.setResponseHead(responseHead);
        }

        responseHead.setReturnStatus("S");
        CrcbHubResponseCode code = new CrcbHubResponseCode();
        code.setReturnCode("000000");
        code.setReturnMsg("交易成功");
        responseHead.setRet(new CrcbHubResponseCode[]{code});
    }

    @JsonIgnore
    public void setError(UnifyErrorCode error) {
        this.setError(error.getCode(), error.getMsg());
    }

    @JsonIgnore
    public void setError(UnifyErrorCode error, String message) {
        this.setError(error.getCode(), message);
    }

    /**
     * 设置响应状态为失败
     *
     * @param exption
     */
    @JsonIgnore
    public void setError(UnifyException exption) {
        this.setError(exption.getCustomState(), exption.getMessage());
    }

    /**
     * 设置响应状态为失败
     *
     * @param errCode
     * @param mesage
     */
    @JsonIgnore
    public void setError(String errCode, String mesage) {
        CrcbHubResponseHead responseHead = this.getResponseHead();
        if (responseHead == null) {
            responseHead = new CrcbHubResponseHead();
            this.setResponseHead(responseHead);
        }

        responseHead.setReturnStatus("F");
        CrcbHubResponseCode code = new CrcbHubResponseCode();
        code.setReturnCode(errCode);
        code.setReturnMsg(mesage);
        responseHead.setRet(new CrcbHubResponseCode[]{code});
    }

    @JsonIgnore
    public void checkError() throws UnifyException {
        CrcbHubResponseHead responseHead = this.getResponseHead();
        if (responseHead == null) {
            throw new UnifyException(UnifyErrorCode.NON_DATA, "服务端未响应正确的报文头");
        } else {
            if (!"S".equalsIgnoreCase(responseHead.getReturnStatus())) {
                CrcbHubResponseCode[] responseCodes = responseHead.getRet();
                if (responseCodes == null || responseCodes.length == 0) {
                    throw new UnifyException(UnifyErrorCode.NON_DATA, "服务端未响应正确的状态码");
                } else {
                    CrcbHubResponseCode err = responseCodes[0];
                    throw new UnifyException(err.getReturnCode(), "服务端响应 错误码[" + err.getReturnCode() + "] " + err.getReturnMsg());
                }
            }
        }
    }

    @JsonIgnore
    public boolean isSuccess() {
        CrcbHubResponseHead responseHead = this.getResponseHead();
        return responseHead != null && "S".equalsIgnoreCase(getResponseHead().getReturnStatus());
    }

    public CrcbHubResponseHead getResponseHead() {
        return responseHead;
    }

    public void setResponseHead(CrcbHubResponseHead responseHead) {
        this.responseHead = responseHead;
    }

    public T getResponseBody() {
        return responseBody;
    }

    public void setResponseBody(T responseBody) {
        this.responseBody = responseBody;
    }
}
