package com.help.crcb.hub;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.help.iap.ApprTellerInfo;
import com.help.iap.AuthTellerInfo;

/**
 * HELP平台业务枢纽响应头
 *
 * @author: YuBin-002726
 * @Date: 2019/5/17 18:26
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CrcbHubResponseHead {

    public CrcbHubResponseHead() {
        CrcbHubResponseCode[] code = new CrcbHubResponseCode[1];
        code[0] = new CrcbHubResponseCode();
        code[0].setReturnCode("000000");
        code[0].setReturnMsg("交易成功");
        this.ret = code;
        this.setReturnStatus("S");
    }

    //服务代码,同请求
    private String serviceCode;

    //服务场景,同请求
    private String serviceScene;

    //消费系统编号,同请求
    private String consumerId;

    //目标系统编号
    private String targetId;

    //服务方渠道类型
    private String channelTyp;

    //发起方系统编号,同请求
    private String orgConsumerId;

    //系统流水号,同请求
    private String consumerSeqNo;

    //服务方系统流水号
    private String splrSeqNo;

    //发起方业务流水号,同请求
    private String orgConsumerSeqNo;

    //交易日期 yyyyMMdd格式
    private String tranDate;

    //交易时间 HHmmss格式
    private String tranTime;

    //交易返回状态
    private String returnStatus = "S";

    private CrcbHubResponseCode[] ret;

    //终端号,同请求
    private String terminalCode;

    //发起方终端号,同请求
    private String orgTerminalCode;

    //消费系统服务器标识(IP地址),同请求
    private String consumerSvrId;

    //发起方服务器标识(IP地址),同请求
    private String orgConsumerSvrId;

    //目标服务器标志
    private String destSvrId;

    //用户语言,同输入
    private String userLang;

    //文件标志
    private String filFlg = "0";

    //文件路径
    private String filPath;

    //柜员号
    private String tellerNo;

    //机构代码
    private String branchId;

    //柜员密码
    private String tellerPassword;

    //柜员级别
    private String tellerLevel;

    //柜员类别
    private String tellerType;

    //复核标志
    private String apprFlag;

    //录入柜员数组
    private ApprTellerInfo[] apprTellerArray;

    //授权标志
    private String authFlag;

    //授权柜员信息数组
    private AuthTellerInfo[] authTellerInfo;

    //每页记录数
    private String pageTotalNum;

    //当前页码
    private String currentPageNum;

    //总记录数
    private String totalNum;

    //本页第一笔
    private String pageStart;

    //本页最后一笔
    private String pageEnd;

    public String getServiceCode() {
        return serviceCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public String getServiceScene() {
        return serviceScene;
    }

    public void setServiceScene(String serviceScene) {
        this.serviceScene = serviceScene;
    }

    public String getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public String getTargetId() {
        return targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public String getChannelTyp() {
        return channelTyp;
    }

    public void setChannelTyp(String channelTyp) {
        this.channelTyp = channelTyp;
    }

    public String getOrgConsumerId() {
        return orgConsumerId;
    }

    public void setOrgConsumerId(String orgConsumerId) {
        this.orgConsumerId = orgConsumerId;
    }

    public String getConsumerSeqNo() {
        return consumerSeqNo;
    }

    public void setConsumerSeqNo(String consumerSeqNo) {
        this.consumerSeqNo = consumerSeqNo;
    }

    public String getSplrSeqNo() {
        return splrSeqNo;
    }

    public void setSplrSeqNo(String splrSeqNo) {
        this.splrSeqNo = splrSeqNo;
    }

    public String getOrgConsumerSeqNo() {
        return orgConsumerSeqNo;
    }

    public void setOrgConsumerSeqNo(String orgConsumerSeqNo) {
        this.orgConsumerSeqNo = orgConsumerSeqNo;
    }

    public String getTranDate() {
        return tranDate;
    }

    public void setTranDate(String tranDate) {
        this.tranDate = tranDate;
    }

    public String getTranTime() {
        return tranTime;
    }

    public void setTranTime(String tranTime) {
        this.tranTime = tranTime;
    }

    public String getReturnStatus() {
        return returnStatus;
    }

    public void setReturnStatus(String returnStatus) {
        this.returnStatus = returnStatus;
    }

    public CrcbHubResponseCode[] getRet() {
        return ret;
    }

    public void setRet(CrcbHubResponseCode[] ret) {
        this.ret = ret;
    }

    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }

    public String getOrgTerminalCode() {
        return orgTerminalCode;
    }

    public void setOrgTerminalCode(String orgTerminalCode) {
        this.orgTerminalCode = orgTerminalCode;
    }

    public String getConsumerSvrId() {
        return consumerSvrId;
    }

    public void setConsumerSvrId(String consumerSvrId) {
        this.consumerSvrId = consumerSvrId;
    }

    public String getOrgConsumerSvrId() {
        return orgConsumerSvrId;
    }

    public void setOrgConsumerSvrId(String orgConsumerSvrId) {
        this.orgConsumerSvrId = orgConsumerSvrId;
    }

    public String getDestSvrId() {
        return destSvrId;
    }

    public void setDestSvrId(String destSvrId) {
        this.destSvrId = destSvrId;
    }

    public String getUserLang() {
        return userLang;
    }

    public void setUserLang(String userLang) {
        this.userLang = userLang;
    }

    public String getFilFlg() {
        return filFlg;
    }

    public void setFilFlg(String filFlg) {
        this.filFlg = filFlg;
    }

    public String getFilPath() {
        return filPath;
    }

    public void setFilPath(String filPath) {
        this.filPath = filPath;
    }

    public String getTellerNo() {
        return tellerNo;
    }

    public void setTellerNo(String tellerNo) {
        this.tellerNo = tellerNo;
    }

    public String getBranchId() {
        return branchId;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    public String getTellerPassword() {
        return tellerPassword;
    }

    public void setTellerPassword(String tellerPassword) {
        this.tellerPassword = tellerPassword;
    }

    public String getTellerLevel() {
        return tellerLevel;
    }

    public void setTellerLevel(String tellerLevel) {
        this.tellerLevel = tellerLevel;
    }

    public String getTellerType() {
        return tellerType;
    }

    public void setTellerType(String tellerType) {
        this.tellerType = tellerType;
    }

    public String getApprFlag() {
        return apprFlag;
    }

    public void setApprFlag(String apprFlag) {
        this.apprFlag = apprFlag;
    }

    public ApprTellerInfo[] getApprTellerArray() {
        return apprTellerArray;
    }

    public void setApprTellerArray(ApprTellerInfo[] apprTellerArray) {
        this.apprTellerArray = apprTellerArray;
    }

    public String getAuthFlag() {
        return authFlag;
    }

    public void setAuthFlag(String authFlag) {
        this.authFlag = authFlag;
    }

    public AuthTellerInfo[] getAuthTellerInfo() {
        return authTellerInfo;
    }

    public void setAuthTellerInfo(AuthTellerInfo[] authTellerInfo) {
        this.authTellerInfo = authTellerInfo;
    }

    public String getPageTotalNum() {
        return pageTotalNum;
    }

    public void setPageTotalNum(String pageTotalNum) {
        this.pageTotalNum = pageTotalNum;
    }

    public String getCurrentPageNum() {
        return currentPageNum;
    }

    public void setCurrentPageNum(String currentPageNum) {
        this.currentPageNum = currentPageNum;
    }

    public String getPageStart() {
        return pageStart;
    }

    public void setPageStart(String pageStart) {
        this.pageStart = pageStart;
    }

    public String getPageEnd() {
        return pageEnd;
    }

    public void setPageEnd(String pageEnd) {
        this.pageEnd = pageEnd;
    }

    public String getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(String totalNum) {
        this.totalNum = totalNum;
    }
}
