package com.help.crcb.hub;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.help.common.validate.Length;
import com.help.iap.ApprTellerInfo;
import com.help.iap.AuthTellerInfo;

/**
 * HELP平台业务枢纽请求头
 *
 * @author: YuBin-002726
 * @Date: 2019/5/17 16:30
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CrcbHubRequestHead {

    //服务代码
    private String serviceCode;

    //服务场景
    private String serviceScene = "01";

    //消费系统编号
//    @Length(max = 8)
    private String consumerId;

    //请求方渠道类型
//    @Length(max = 2)
    private String channelTyp;

    //发起方系统编号
//    @Length(max = 8)
    private String orgConsumerId;

    //系统流水号
//    @Length(max = 52)
    private String consumerSeqNo;

    //发起方业务流水号
//    @Length(max = 52)
    private String orgConsumerSeqNo;

    //交易模式
//    @Length(max = 10)
    private String tranMode;

    //交易日期 yyyyMMdd格式
//    @Length(max = 8)
    private String tranDate;

    //交易时间 HHmmss格式
//    @Length(max = 6)
    private String tranTime;

    //终端号
//    @Length(max = 30)
    private String terminalCode;

    //发起方终端号
//    @Length(max = 30)
    private String orgTerminalCode;

    //消费系统服务器标识(IP地址)
//    @Length(max = 30)
    private String consumerSvrId;

    //发起方服务器标识(IP地址)
//    @Length(max = 30)
    private String orgConsumerSvrId;

    //用户语言
//    @Length(max = 20)
    private String userLang;

    //文件标志
//    @Length(max = 1)
    private String filFlg = "0";

    //文件路径
//    @Length(max = 100)
    private String filPath;

    //柜员号
//    @Length(max = 10)
    private String tellerNo;

    //机构代码
//    @Length(max = 30)
    private String branchId;

    //柜员密码
//    @Length(max = 30)
    private String tellerPassword;

    //柜员级别
//    @Length(max = 10)
    private String tellerLevel;

    //柜员类别
//    @Length(max = 10)
    private String tellerType;

    //复核标志
//    @Length(max = 1)
    private String apprFlag;

    //录入柜员数组
    private ApprTellerInfo[] apprTellerArray;

    //授权标志
//    @Length(max = 1)
    private String authFlag;

    //授权柜员信息数组
    private AuthTellerInfo[] authTellerInfo;

    //法人代码 常熟:001
    private String legalRepCode = "001";

    //MAC值
//    @Length(max = 16)
    private String mac;

    //密钥ID（用于Pin、Mac）
//    @Length(max = 12)
    private String keyId;

    //服务名
    private String serviceName;

    //交易码
//    @Length(max = 10)
    private String tranCode;

    //扩展内容
//    @Length(max = 128)
    private String extendContent;

    //鉴权信息
    private String servToken;

    public String getServiceCode() {
        return serviceCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public String getServiceScene() {
        return serviceScene;
    }

    public void setServiceScene(String serviceScene) {
        this.serviceScene = serviceScene;
    }

    public String getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public String getChannelTyp() {
        return channelTyp;
    }

    public void setChannelTyp(String channelTyp) {
        this.channelTyp = channelTyp;
    }

    public String getOrgConsumerId() {
        return orgConsumerId;
    }

    public void setOrgConsumerId(String orgConsumerId) {
        this.orgConsumerId = orgConsumerId;
    }

    public String getConsumerSeqNo() {
        return consumerSeqNo;
    }

    public void setConsumerSeqNo(String consumerSeqNo) {
        this.consumerSeqNo = consumerSeqNo;
    }

    public String getOrgConsumerSeqNo() {
        return orgConsumerSeqNo;
    }

    public void setOrgConsumerSeqNo(String orgConsumerSeqNo) {
        this.orgConsumerSeqNo = orgConsumerSeqNo;
    }

    public String getTranMode() {
        return tranMode;
    }

    public void setTranMode(String tranMode) {
        this.tranMode = tranMode;
    }

    public String getTranDate() {
        return tranDate;
    }

    public void setTranDate(String tranDate) {
        this.tranDate = tranDate;
    }

    public String getTranTime() {
        return tranTime;
    }

    public void setTranTime(String tranTime) {
        this.tranTime = tranTime;
    }

    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }

    public String getOrgTerminalCode() {
        return orgTerminalCode;
    }

    public void setOrgTerminalCode(String orgTerminalCode) {
        this.orgTerminalCode = orgTerminalCode;
    }

    public String getConsumerSvrId() {
        return consumerSvrId;
    }

    public void setConsumerSvrId(String consumerSvrId) {
        this.consumerSvrId = consumerSvrId;
    }

    public String getOrgConsumerSvrId() {
        return orgConsumerSvrId;
    }

    public void setOrgConsumerSvrId(String orgConsumerSvrId) {
        this.orgConsumerSvrId = orgConsumerSvrId;
    }

    public String getUserLang() {
        return userLang;
    }

    public void setUserLang(String userLang) {
        this.userLang = userLang;
    }

    public String getFilFlg() {
        return filFlg;
    }

    public void setFilFlg(String filFlg) {
        this.filFlg = filFlg;
    }

    public String getFilPath() {
        return filPath;
    }

    public void setFilPath(String filPath) {
        this.filPath = filPath;
    }

    public String getTellerNo() {
        return tellerNo;
    }

    public void setTellerNo(String tellerNo) {
        this.tellerNo = tellerNo;
    }

    public String getBranchId() {
        return branchId;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    public String getTellerPassword() {
        return tellerPassword;
    }

    public void setTellerPassword(String tellerPassword) {
        this.tellerPassword = tellerPassword;
    }

    public String getTellerLevel() {
        return tellerLevel;
    }

    public void setTellerLevel(String tellerLevel) {
        this.tellerLevel = tellerLevel;
    }

    public String getTellerType() {
        return tellerType;
    }

    public void setTellerType(String tellerType) {
        this.tellerType = tellerType;
    }

    public String getApprFlag() {
        return apprFlag;
    }

    public void setApprFlag(String apprFlag) {
        this.apprFlag = apprFlag;
    }

    public ApprTellerInfo[] getApprTellerArray() {
        return apprTellerArray;
    }

    public void setApprTellerArray(ApprTellerInfo[] apprTellerArray) {
        this.apprTellerArray = apprTellerArray;
    }

    public String getAuthFlag() {
        return authFlag;
    }

    public void setAuthFlag(String authFlag) {
        this.authFlag = authFlag;
    }

    public AuthTellerInfo[] getAuthTellerInfo() {
        return authTellerInfo;
    }

    public void setAuthTellerInfo(AuthTellerInfo[] authTellerInfo) {
        this.authTellerInfo = authTellerInfo;
    }

    public String getLegalRepCode() {
        return legalRepCode;
    }

    public void setLegalRepCode(String legalRepCode) {
        this.legalRepCode = legalRepCode;
    }

    public String getMac() {
        return mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getKeyId() {
        return keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getTranCode() {
        return tranCode;
    }

    public void setTranCode(String tranCode) {
        this.tranCode = tranCode;
    }

    public String getExtendContent() {
        return extendContent;
    }

    public void setExtendContent(String extendContent) {
        this.extendContent = extendContent;
    }

    public String getServToken() {
        return servToken;
    }

    public void setServToken(String servToken) {
        this.servToken = servToken;
    }
}
