/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.Security;
import com.help.common.util.StringUtil;
import com.help.constant.EmployeeType;
import com.help.dao.PUserAffiliationMapper;
import com.help.dao.PUserMapper;
import com.help.domain.PUser;
import com.help.domain.PUserAffiliationExample;
import com.help.domain.PUserExample;
import com.help.domain.UserInfo;
import com.help.storage.editable.IEditableUserStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

public class HelpLocalUserStorage
implements IEditableUserStorage {
    PUserMapper pUserMapper;
    PUserAffiliationMapper pUserAffiliationMapper;
    boolean legalable;

    public HelpLocalUserStorage(boolean legalable, PUserMapper pUserMapper, PUserAffiliationMapper pUserAffiliationMapper) {
        this.pUserMapper = pUserMapper;
        this.pUserAffiliationMapper = pUserAffiliationMapper;
        this.legalable = legalable;
    }

    protected String getLegal() {
        return null;
    }

    private boolean matchLegal(String legal) {
        if (!this.legalable) {
            return true;
        }
        String current = this.getLegal();
        return current == null || current.equalsIgnoreCase(legal);
    }

    public UserInfo get(String userNo) {
        PUser pUser = this.pUserMapper.selectByPrimaryKey(userNo);
        if (pUser != null && this.matchLegal(pUser.getLegalPersonality())) {
            return this.transform(pUser);
        }
        return null;
    }

    public List<UserInfo> getAll(String ... userNos) {
        if (userNos != null && userNos.length > 0) {
            PUserExample example = new PUserExample();
            example.createCriteria().andUserNoIn((List)Arrays.asList(userNos)).andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
            return this.pUserMapper.selectByExample(example).stream().map(p -> this.transform((PUser)p)).collect(Collectors.toList());
        }
        return new ArrayList<UserInfo>();
    }

    public UserInfo get(String userNo, String password) {
        PUser user = this.pUserMapper.selectByPrimaryKey(userNo);
        if (user != null && this.matchLegal(user.getLegalPersonality()) && Security.toSHA256((String)password).toUpperCase().equals(user.getPassword().toUpperCase())) {
            return this.transform(user);
        }
        return null;
    }

    public UserInfo getByJobNumber(String jobNumber) {
        if (StringUtil.isNotEmpty((String)jobNumber)) {
            PUserExample exp = new PUserExample();
            exp.createCriteria().andJobNumberEqualTo(jobNumber).andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
            return this.transform((PUser)this.pUserMapper.selectByExample(exp).stream().findAny().orElse(null));
        }
        return null;
    }

    public UserInfo getByPhone(String phone) {
        if (StringUtil.isNotEmpty((String)phone)) {
            PUserExample exp = new PUserExample();
            exp.createCriteria().andPhoneEqualTo(phone).andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
            return this.transform((PUser)this.pUserMapper.selectByExample(exp).stream().findAny().orElse(null));
        }
        return null;
    }

    public List<UserInfo> list() {
        PUserExample example = new PUserExample();
        example.createCriteria().andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        return this.pUserMapper.selectByExample(example).stream().map(p -> this.transform((PUser)p)).collect(Collectors.toList());
    }

    public UnifyPageData<UserInfo> listByPage(UnifyPageInfo pageInfo) {
        PUserExample example = new PUserExample();
        example.createCriteria().andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        PageHelper.startPage((int)pageInfo.getPageIndex(), (int)pageInfo.getPageSize());
        List<PUser> list = this.pUserMapper.selectByExample(example);
        PageInfo info = new PageInfo(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData((Collection)info.getList().stream().map(p -> this.transform((PUser)p)).collect(Collectors.toList()), pageInfo);
    }

    public UnifyPageData<UserInfo> searchByPage(String user, String orgNo, String deptNo, UnifyPageInfo pageInfo) {
        PUserExample.Criteria criteria;
        String legal = this.getLegal();
        PUserExample example = new PUserExample();
        if (StringUtil.isNotEmpty((String)user)) {
            criteria = example.createCriteria().andUserNameLike("%" + user + "%").andLegalPersonalityEqualToNotEmptyValue(legal);
            PUserExample.Criteria orCriteria = example.or().andUserNoLike("%" + user + "%").andLegalPersonalityEqualToNotEmptyValue(legal);
            if (StringUtil.isNotEmpty((String)orgNo)) {
                criteria.andOrgNoEqualTo(orgNo);
                orCriteria.andOrgNoEqualTo(orgNo);
            }
            if (StringUtil.isNotEmpty((String)deptNo)) {
                criteria.andDeptNoEqualTo(deptNo);
                orCriteria.andDeptNoEqualTo(deptNo);
            }
        } else {
            criteria = example.createCriteria().andLegalPersonalityEqualToNotEmptyValue(legal);
            if (StringUtil.isNotEmpty((String)orgNo)) {
                criteria.andOrgNoEqualTo(orgNo);
            }
            if (StringUtil.isNotEmpty((String)deptNo)) {
                criteria.andDeptNoEqualTo(deptNo);
            }
        }
        PageHelper.startPage((int)pageInfo.getPageIndex(), (int)pageInfo.getPageSize());
        List<PUser> list = this.pUserMapper.selectByExample(example);
        PageInfo info = new PageInfo(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData((Collection)info.getList().stream().map(p -> this.transform((PUser)p)).collect(Collectors.toList()), pageInfo);
    }

    public void add(UserInfo userInfo) {
        if (!this.matchLegal(userInfo.getLegalPersonality())) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u60a8\u53ea\u80fd\u65b0\u589e\u81ea\u8eab\u6cd5\u4eba\u4e0b\u7684\u7528\u6237\u4fe1\u606f");
        }
        PUser user = this.transform(userInfo);
        user.setPassword(Security.toSHA256((String)userInfo.getPassword()));
        if (user.getCreateTime() == null) {
            user.setCreateTime(new Date());
        }
        this.pUserMapper.insert(user);
    }

    public void edit(UserInfo userInfo) {
        if (!this.matchLegal(userInfo.getLegalPersonality())) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u60a8\u53ea\u80fd\u4fee\u6539\u81ea\u8eab\u6cd5\u4eba\u4e0b\u7684\u7528\u6237\u4fe1\u606f");
        }
        PUser user = this.transform(userInfo);
        this.pUserMapper.updateColumnsByPrimaryKey(user, "state", "certCode", "creater", "email", "phone", "remark", "userName", "userNo", "orgNo", "deptNo", "type", "jobNumber", "legalPersonality");
    }

    @Transactional
    public void delete(String userNo) {
        UserInfo user = this.get(userNo);
        if (user == null) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
        }
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andUserNoEqualTo(userNo);
        this.pUserAffiliationMapper.deleteByExample(example);
        this.pUserMapper.deleteByPrimaryKey(userNo);
    }

    public void changeState(String userNo, boolean enable) {
        UserInfo user = this.get(userNo);
        if (user == null) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
        }
        PUser pUser = new PUser();
        pUser.setUserNo(userNo);
        pUser.setState(enable ? "1" : "0");
        this.pUserMapper.updateColumnsByPrimaryKey(pUser, "state");
    }

    public void resetPwd(String userNo, String newPwd) {
        UserInfo user = this.get(userNo);
        if (user == null) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
        }
        PUser pUser = new PUser();
        pUser.setUserNo(userNo);
        pUser.setPassword(Security.toSHA256((String)newPwd));
        this.pUserMapper.updateColumnsByPrimaryKey(pUser, "password");
    }

    public boolean resetPwd(String userNo, String oldPwd, String newPwd) {
        PUser pUser = this.pUserMapper.selectColumnsByPrimaryKey(userNo, "userNo", "password");
        if (pUser != null && this.matchLegal(pUser.getLegalPersonality())) {
            if (Security.toSHA256((String)oldPwd).toUpperCase().equals(pUser.getPassword().toUpperCase())) {
                this.resetPwd(userNo, newPwd);
                return true;
            }
            return false;
        }
        throw new UnifyException(UnifyErrorCode.NON_DATA, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728\u6216\u539f\u5bc6\u7801\u9519\u8bef");
    }

    private UserInfo transform(PUser user) {
        if (user == null) {
            return null;
        }
        UserInfo info = new UserInfo();
        info.setState("1".equalsIgnoreCase(user.getState()) ? "1" : "0");
        info.setCertCode(user.getCertCode());
        info.setCreater(user.getCreater());
        info.setCreateTime(user.getCreateTime());
        info.setEmail(user.getEmail());
        info.setPhone(user.getPhone());
        info.setRemark(user.getRemark());
        info.setUserName(user.getUserName());
        info.setUserNo(user.getUserNo());
        info.setOrgNo(user.getOrgNo());
        info.setDeptNo(user.getDeptNo());
        info.setHeadIcon(user.getHeadIcon());
        info.setJobNumber(user.getJobNumber());
        if (StringUtil.isNotEmpty((String)user.getLegalPersonality())) {
            info.setLegalPersonality(user.getLegalPersonality());
        }
        if (StringUtil.isNotEmpty((String)user.getType())) {
            info.setType(EmployeeType.valueOf((String)user.getType()));
        } else {
            info.setType(EmployeeType.TEMPORARY);
        }
        return info;
    }

    private PUser transform(UserInfo user) {
        if (user == null) {
            return null;
        }
        PUser info = new PUser();
        info.setState("1".equalsIgnoreCase(user.getState()) ? "1" : "0");
        info.setCertCode(user.getCertCode());
        info.setCreater(user.getCreater());
        info.setCreateTime(user.getCreateTime());
        info.setEmail(user.getEmail());
        info.setPhone(user.getPhone());
        info.setRemark(user.getRemark());
        info.setUserName(user.getUserName());
        info.setUserNo(user.getUserNo());
        info.setJobNumber(user.getJobNumber());
        info.setOrgNo(user.getOrgNo());
        info.setDeptNo(user.getDeptNo());
        info.setPassword(user.getPassword());
        info.setHeadIcon(user.getHeadIcon());
        info.setType(user.getType().name());
        if (StringUtil.isNotEmpty((String)user.getLegalPersonality())) {
            info.setLegalPersonality(user.getLegalPersonality());
        }
        return info;
    }

    public HelpLocalUserStorage getEditableLegalProxy(final String legal) {
        if (!this.legalable) {
            return this;
        }
        return new HelpLocalUserStorage(true, this.pUserMapper, this.pUserAffiliationMapper){

            @Override
            protected String getLegal() {
                return legal;
            }
        };
    }

    public HelpLocalUserStorage getLegalProxy(String legal) {
        return this.getEditableLegalProxy(legal);
    }
}

