/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.dao.PUserAffiliationMapper;
import com.help.dao.PUserMapper;
import com.help.domain.PUser;
import com.help.domain.PUserAffiliation;
import com.help.domain.PUserAffiliationExample;
import com.help.domain.UserAffiliationInfo;
import com.help.storage.IUserAffiliationStorage;
import com.help.storage.editable.IEditableUserAffiliationStorage;
import java.util.List;
import java.util.stream.Collectors;

public class HelpLocalUserAffiliationStorage
implements IEditableUserAffiliationStorage {
    PUserMapper pUserMapper;
    PUserAffiliationMapper pUserAffiliationMapper;
    boolean legalable;

    public HelpLocalUserAffiliationStorage(boolean legalable, PUserMapper pUserMapper, PUserAffiliationMapper pUserAffiliationMapper) {
        this.pUserMapper = pUserMapper;
        this.pUserAffiliationMapper = pUserAffiliationMapper;
        this.legalable = legalable;
    }

    protected String getLegal() {
        return null;
    }

    private boolean matchLegal(String legal) {
        if (!this.legalable) {
            return true;
        }
        String current = this.getLegal();
        return current == null || current.equalsIgnoreCase(legal);
    }

    public List<String> listRoleByUser(String userNo) {
        PUser user = this.pUserMapper.selectByPrimaryKey(userNo);
        if (user != null && this.matchLegal(user.getLegalPersonality())) {
            PUserAffiliationExample example = new PUserAffiliationExample();
            example.createCriteria().andUserNoEqualTo(userNo).andRoleNoNotEmpty();
            example.setDistinct(true);
            return this.pUserAffiliationMapper.selectColumnsByExample(example, "roleNo").stream().map(p -> p.getRoleNo()).collect(Collectors.toList());
        }
        throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
    }

    public List<String> listRoleByUserAndOrg(String userNo, String orgNo) {
        PUser user = this.pUserMapper.selectByPrimaryKey(userNo);
        if (user != null && this.matchLegal(user.getLegalPersonality())) {
            PUserAffiliationExample example = new PUserAffiliationExample();
            example.createCriteria().andUserNoEqualTo(userNo).andTypeEqualTo("ORG").andAffiliationNoEqualTo(orgNo);
            return this.pUserAffiliationMapper.selectColumnsByExample(example, "roleNo").stream().map(p -> p.getRoleNo()).collect(Collectors.toList());
        }
        throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
    }

    public List<String> listRoleByUserAndDept(String userNo, String deptNo) {
        PUser user = this.pUserMapper.selectByPrimaryKey(userNo);
        if (user != null && this.matchLegal(user.getLegalPersonality())) {
            PUserAffiliationExample example = new PUserAffiliationExample();
            example.createCriteria().andUserNoEqualTo(userNo).andTypeEqualTo("DEPT").andAffiliationNoEqualTo(deptNo);
            return this.pUserAffiliationMapper.selectColumnsByExample(example, "roleNo").stream().map(p -> p.getRoleNo()).collect(Collectors.toList());
        }
        throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
    }

    public List<UserAffiliationInfo> listRoleAffiliationByUser(String userNo) {
        PUser user = this.pUserMapper.selectByPrimaryKey(userNo);
        if (user != null && this.matchLegal(user.getLegalPersonality())) {
            PUserAffiliationExample example = new PUserAffiliationExample();
            example.createCriteria().andUserNoEqualTo(userNo);
            return this.pUserAffiliationMapper.selectByExample(example).stream().map(p -> this.transform((PUserAffiliation)p)).collect(Collectors.toList());
        }
        throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
    }

    public List<String> listUserNoByOrgAndRole(String org, String role) {
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andTypeEqualTo("ORG").andAffiliationNoEqualTo(org).andRoleNoEqualTo(role).andUserLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        return this.pUserAffiliationMapper.selectColumnsByExample(example, "userNo").stream().map(p -> p.getUserNo()).collect(Collectors.toList());
    }

    public List<String> listUserNoByDeptAndRole(String dept, String role) {
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andTypeEqualTo("DEPT").andAffiliationNoEqualTo(dept).andRoleNoEqualTo(role).andUserLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        return this.pUserAffiliationMapper.selectColumnsByExample(example, "userNo").stream().map(p -> p.getUserNo()).collect(Collectors.toList());
    }

    public List<UserAffiliationInfo> listRoleAffiliationByOrg(String orgNo) {
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andTypeEqualTo("ORG").andAffiliationNoEqualTo(orgNo).andUserLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        return this.pUserAffiliationMapper.selectByExample(example).stream().map(p -> this.transform((PUserAffiliation)p)).collect(Collectors.toList());
    }

    public List<UserAffiliationInfo> listRoleAffiliationByDept(String deptNo) {
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andTypeEqualTo("DEPT").andAffiliationNoEqualTo(deptNo).andUserLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        return this.pUserAffiliationMapper.selectByExample(example).stream().map(p -> this.transform((PUserAffiliation)p)).collect(Collectors.toList());
    }

    public List<UserAffiliationInfo> listRoleAffiliationByRole(String roleNo) {
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andRoleNoEqualTo(roleNo).andUserLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        return this.pUserAffiliationMapper.selectByExample(example).stream().map(p -> this.transform((PUserAffiliation)p)).collect(Collectors.toList());
    }

    public void addUserToRole(String userNo, String roleNo) {
        PUser user = this.pUserMapper.selectByPrimaryKey(userNo);
        if (user != null && this.matchLegal(user.getLegalPersonality())) {
            PUserAffiliationExample example = new PUserAffiliationExample();
            example.createCriteria().andUserNoEqualTo(userNo).andRoleNoEqualTo(roleNo).andTypeEqualTo("");
            if (this.pUserAffiliationMapper.countByExample(example) == 0L) {
                PUserAffiliation aff = new PUserAffiliation();
                aff.setAffiliationNo("");
                aff.setType("");
                aff.setUserNo(userNo);
                aff.setRoleNo(roleNo);
                this.pUserAffiliationMapper.insert(aff);
            }
        } else {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
        }
    }

    public void addUserToOrgRole(String userNo, String orgNo, String roleNo) {
        PUser user = this.pUserMapper.selectByPrimaryKey(userNo);
        if (user != null && this.matchLegal(user.getLegalPersonality())) {
            PUserAffiliationExample example = new PUserAffiliationExample();
            example.createCriteria().andUserNoEqualTo(userNo).andRoleNoEqualTo(roleNo).andTypeEqualTo("ORG").andAffiliationNoEqualTo(orgNo);
            if (this.pUserAffiliationMapper.countByExample(example) == 0L) {
                PUserAffiliation aff = new PUserAffiliation();
                aff.setAffiliationNo(orgNo);
                aff.setType("ORG");
                aff.setUserNo(userNo);
                aff.setRoleNo(roleNo);
                this.pUserAffiliationMapper.insert(aff);
            }
        } else {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
        }
    }

    public void addUserToDeptRole(String userNo, String deptNo, String roleNo) {
        PUser user = this.pUserMapper.selectByPrimaryKey(userNo);
        if (user != null && this.matchLegal(user.getLegalPersonality())) {
            PUserAffiliationExample example = new PUserAffiliationExample();
            example.createCriteria().andUserNoEqualTo(userNo).andRoleNoEqualTo(roleNo).andTypeEqualTo("DEPT").andAffiliationNoEqualTo(deptNo);
            if (this.pUserAffiliationMapper.countByExample(example) == 0L) {
                PUserAffiliation aff = new PUserAffiliation();
                aff.setAffiliationNo(deptNo);
                aff.setType("DEPT");
                aff.setUserNo(userNo);
                aff.setRoleNo(roleNo);
                this.pUserAffiliationMapper.insert(aff);
            }
        } else {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
        }
    }

    public void removeUserFromRole(String userNo, String roleNo) {
        PUser user = this.pUserMapper.selectByPrimaryKey(userNo);
        if (user == null || !this.matchLegal(user.getLegalPersonality())) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
        }
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andUserNoEqualTo(userNo).andRoleNoEqualTo(roleNo).andTypeEqualTo("");
        this.pUserAffiliationMapper.deleteByExample(example);
    }

    public void removeUserFromOrgRole(String userNo, String orgNo, String roleNo) {
        PUser user = this.pUserMapper.selectByPrimaryKey(userNo);
        if (user == null || !this.matchLegal(user.getLegalPersonality())) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
        }
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andUserNoEqualTo(userNo).andRoleNoEqualTo(roleNo).andTypeEqualTo("ORG").andAffiliationNoEqualTo(orgNo);
        this.pUserAffiliationMapper.deleteByExample(example);
    }

    public void removeUserFromDeptRole(String userNo, String deptNo, String roleNo) {
        PUser user = this.pUserMapper.selectByPrimaryKey(userNo);
        if (user == null || !this.matchLegal(user.getLegalPersonality())) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u7528\u6237[" + userNo + "]\u4e0d\u5b58\u5728");
        }
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andUserNoEqualTo(userNo).andRoleNoEqualTo(roleNo).andTypeEqualTo("DEPT").andAffiliationNoEqualTo(deptNo);
        this.pUserAffiliationMapper.deleteByExample(example);
    }

    public void removeAllUsersByOrg(String orgNo) {
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andTypeEqualTo("ORG").andAffiliationNoEqualTo(orgNo).andUserLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        this.pUserAffiliationMapper.deleteByExample(example);
    }

    public void removeAllUsersByDept(String deptNo) {
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andTypeEqualTo("DEPT").andAffiliationNoEqualTo(deptNo).andUserLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        this.pUserAffiliationMapper.deleteByExample(example);
    }

    public void removeAllUsersByRole(String roleNo) {
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andRoleNoEqualTo(roleNo).andUserLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        this.pUserAffiliationMapper.deleteByExample(example);
    }

    private UserAffiliationInfo transform(PUserAffiliation p) {
        if (p == null) {
            return null;
        }
        UserAffiliationInfo info = new UserAffiliationInfo();
        info.setUserNo(p.getUserNo());
        info.setAffiNo(p.getAffiliationNo());
        info.setAffiType(p.getType());
        info.setRoleNo(p.getRoleNo());
        return info;
    }

    public IEditableUserAffiliationStorage getEditableLegalProxy(final String legal) {
        if (!this.legalable) {
            return this;
        }
        return new HelpLocalUserAffiliationStorage(true, this.pUserMapper, this.pUserAffiliationMapper){

            @Override
            protected String getLegal() {
                return legal;
            }
        };
    }

    public IUserAffiliationStorage getLegalProxy(String legal) {
        return this.getEditableLegalProxy(legal);
    }
}

