/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.StringUtil;
import com.help.dao.POrgMapper;
import com.help.dao.PUserAffiliationMapper;
import com.help.domain.OrgInfoBase;
import com.help.domain.OrgNode;
import com.help.domain.POrg;
import com.help.domain.POrgExample;
import com.help.domain.PUserAffiliationExample;
import com.help.storage.editable.IEditableOrgStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

public class HelpLocalOrgStorage
implements IEditableOrgStorage {
    POrgMapper pOrgMapper;
    PUserAffiliationMapper pUserAffiliationMapper;
    boolean legalable;

    public HelpLocalOrgStorage(boolean legalable, POrgMapper pOrgMapper, PUserAffiliationMapper pUserAffiliationMapper) {
        this.pOrgMapper = pOrgMapper;
        this.pUserAffiliationMapper = pUserAffiliationMapper;
        this.legalable = legalable;
    }

    protected String getLegal() {
        return null;
    }

    private boolean matchLegal(String legal) {
        if (!this.legalable) {
            return true;
        }
        String current = this.getLegal();
        return current == null || current.equalsIgnoreCase(legal);
    }

    public void add(OrgInfoBase node) {
        if (!this.matchLegal(node.getLegalPersonality())) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u60a8\u53ea\u80fd\u65b0\u589e\u81ea\u8eab\u6cd5\u4eba\u4e0b\u7684\u673a\u6784\u4fe1\u606f");
        }
        this.pOrgMapper.insert(this.transform(node));
    }

    public void edit(OrgInfoBase node) {
        if (!this.matchLegal(node.getLegalPersonality())) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u60a8\u53ea\u80fd\u4fee\u6539\u81ea\u8eab\u6cd5\u4eba\u4e0b\u7684\u673a\u6784\u4fe1\u606f");
        }
        this.pOrgMapper.updateByPrimaryKey(this.transform(node));
    }

    public void changeState(String orgNo, boolean enable) {
        OrgInfoBase org = this.get(orgNo);
        if (org == null) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u673a\u6784[" + orgNo + "]\u4e0d\u5b58\u5728");
        }
        POrg pOrg = new POrg();
        pOrg.setOrgNo(orgNo);
        pOrg.setState(enable ? "1" : "0");
        this.pOrgMapper.updateColumnsByPrimaryKey(pOrg, "state");
    }

    @Transactional
    public void delete(String orgNo) {
        OrgInfoBase org = this.get(orgNo);
        if (org == null) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u673a\u6784[" + orgNo + "]\u4e0d\u5b58\u5728");
        }
        POrgExample example = new POrgExample();
        example.createCriteria().andSuperOrgNoEqualTo(orgNo);
        POrg pOrg = new POrg();
        pOrg.setSuperOrgNo(null);
        this.pOrgMapper.updateColumnsByExample(pOrg, example, "superOrgNo");
        this.pOrgMapper.deleteByPrimaryKey(orgNo);
        PUserAffiliationExample exp = new PUserAffiliationExample();
        exp.createCriteria().andTypeEqualTo("ORG").andAffiliationNoEqualTo(orgNo);
        this.pUserAffiliationMapper.deleteByExample(exp);
    }

    private void expand(OrgNode node, List<String> result) {
        result.add(node.getOrgNo());
        if (node.getChildren() != null) {
            for (OrgNode n : node.getChildren()) {
                this.expand(n, result);
            }
        }
    }

    @Transactional
    public String[] deleteWithAll(String orgNo) {
        OrgNode node = this.getWithAll(orgNo);
        ArrayList<String> nodes = new ArrayList<String>();
        this.expand(node, nodes);
        if (nodes.size() > 0) {
            POrgExample example = new POrgExample();
            example.createCriteria().andOrgNoIn(nodes);
            this.pOrgMapper.deleteByExample(example);
            PUserAffiliationExample exp = new PUserAffiliationExample();
            exp.createCriteria().andTypeEqualTo("ORG").andAffiliationNoIn(nodes);
            this.pUserAffiliationMapper.deleteByExample(exp);
        }
        return nodes.toArray(new String[0]);
    }

    public List<OrgInfoBase> listAll() {
        POrgExample example = new POrgExample();
        example.createCriteria().andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        return this.pOrgMapper.selectByExample(example).stream().map(p -> this.transform((POrg)p)).collect(Collectors.toList());
    }

    public List<OrgInfoBase> listByType(String type) {
        POrgExample example = new POrgExample();
        example.createCriteria().andTypeEqualTo(type).andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        return this.pOrgMapper.selectByExample(example).stream().map(p -> this.transform((POrg)p)).collect(Collectors.toList());
    }

    public OrgInfoBase get(String orgNo) {
        POrg org = this.pOrgMapper.selectByPrimaryKey(orgNo);
        if (org != null && this.matchLegal(org.getLegalPersonality())) {
            return this.transform(org);
        }
        return null;
    }

    public List<OrgInfoBase> getAll(String ... orgNos) {
        if (orgNos != null && orgNos.length > 0) {
            POrgExample example = new POrgExample();
            example.createCriteria().andOrgNoIn((List)Arrays.asList(orgNos)).andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
            return this.pOrgMapper.selectByExample(example).stream().map(p -> this.transform((POrg)p)).collect(Collectors.toList());
        }
        return new ArrayList<OrgInfoBase>();
    }

    private OrgNode fetchChilds(List<POrg> all, POrg org, int currentLevel, int maxLevel) {
        OrgNode node = this.transformNode(org);
        if (maxLevel > 0 && currentLevel >= maxLevel) {
            return node;
        }
        List childs = all.stream().filter(p -> node.getOrgNo().equals(p.getSuperOrgNo())).collect(Collectors.toList());
        List childNodes = childs.stream().map(c -> this.fetchChilds(all, (POrg)c, currentLevel + 1, maxLevel)).collect(Collectors.toList());
        if (childNodes != null && childNodes.size() > 0) {
            node.setChildren(childNodes);
        }
        return node;
    }

    public OrgNode getWithChilds(String orgNo) {
        POrgExample example = new POrgExample();
        example.createCriteria().andOrgNoEqualTo(orgNo).andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        example.or().andSuperOrgNoEqualTo(orgNo).andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        List<POrg> orgs = this.pOrgMapper.selectByExample(example);
        POrg org = orgs.stream().filter(p -> orgNo.equals(p.getOrgNo())).findFirst().orElse(null);
        if (org == null) {
            return null;
        }
        return this.fetchChilds(orgs, org, 0, 1);
    }

    public OrgNode getWithChilds(String orgNo, int level) {
        if (level < 0) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u673a\u6784\u5c42\u7ea7\u4e0d\u80fd\u5c0f\u4e8e[0]");
        }
        if (level == 0) {
            POrg org = this.pOrgMapper.selectByPrimaryKey(orgNo);
            if (org != null && this.matchLegal(org.getLegalPersonality())) {
                return this.transformNode(org, null);
            }
            return null;
        }
        if (level == 1) {
            return this.getWithChilds(orgNo);
        }
        POrg org = this.pOrgMapper.selectByPrimaryKey(orgNo);
        if (org != null && this.matchLegal(org.getLegalPersonality())) {
            POrgExample exp = new POrgExample();
            exp.createCriteria().andLegalPersonalityEqualToNotEmptyValue(org.getLegalPersonality());
            List<POrg> orgs = this.pOrgMapper.selectByExample(exp);
            return this.fetchChilds(orgs, org, 0, level);
        }
        return null;
    }

    public OrgNode getWithAll(String orgNo) {
        POrg org = this.pOrgMapper.selectByPrimaryKey(orgNo);
        if (org != null && this.matchLegal(org.getLegalPersonality())) {
            POrgExample exp = new POrgExample();
            exp.createCriteria().andLegalPersonalityEqualToNotEmptyValue(org.getLegalPersonality());
            List<POrg> orgs = this.pOrgMapper.selectByExample(exp);
            return this.fetchChilds(orgs, org, 0, -1);
        }
        return null;
    }

    public List<OrgInfoBase> listTop() {
        POrgExample example = new POrgExample();
        example.createCriteria().andSuperOrgNoIsEmpty().andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        return this.pOrgMapper.selectByExample(example).stream().map(p -> this.transform((POrg)p)).collect(Collectors.toList());
    }

    public List<OrgNode> listTopWithChilds() {
        String legal = this.getLegal();
        POrgExample example = new POrgExample();
        example.createCriteria().andSuperOrgNoIsEmpty().andLegalPersonalityEqualToNotEmptyValue(legal);
        List<POrg> tops = this.pOrgMapper.selectByExample(example);
        if (tops.size() == 0) {
            return new ArrayList<OrgNode>();
        }
        List parents = tops.stream().map(p -> p.getOrgNo()).collect(Collectors.toList());
        POrgExample exp = new POrgExample();
        exp.createCriteria().andSuperOrgNoIn(parents).andLegalPersonalityEqualToNotEmptyValue(legal);
        List<POrg> childs = this.pOrgMapper.selectByExample(exp);
        return tops.stream().map(p -> this.fetchChilds(childs, (POrg)p, 0, 1)).collect(Collectors.toList());
    }

    public List<OrgNode> listTopWithChilds(int level) {
        if (level < 0) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u673a\u6784\u5c42\u7ea7\u4e0d\u80fd\u5c0f\u4e8e[0]");
        }
        if (level == 0) {
            POrgExample example = new POrgExample();
            example.createCriteria().andSuperOrgNoIsEmpty().andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
            return this.pOrgMapper.selectByExample(example).stream().map(p -> this.transformNode((POrg)p)).collect(Collectors.toList());
        }
        if (level == 1) {
            return this.listTopWithChilds();
        }
        POrgExample example = new POrgExample();
        example.createCriteria().andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        List<POrg> all = this.pOrgMapper.selectByExample(example);
        List tops = all.stream().filter(p -> StringUtil.isEmpty((String)p.getSuperOrgNo())).collect(Collectors.toList());
        return tops.stream().map(p -> this.fetchChilds(all, (POrg)p, 0, level)).collect(Collectors.toList());
    }

    public List<OrgNode> listTopWithAll() {
        POrgExample example = new POrgExample();
        example.createCriteria().andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        List<POrg> all = this.pOrgMapper.selectByExample(example);
        List tops = all.stream().filter(p -> StringUtil.isEmpty((String)p.getSuperOrgNo())).collect(Collectors.toList());
        return tops.stream().map(p -> this.fetchChilds(all, (POrg)p, 0, -1)).collect(Collectors.toList());
    }

    private POrg transform(OrgInfoBase orgInfoBase) {
        if (orgInfoBase == null) {
            return null;
        }
        POrg pOrg = new POrg();
        pOrg.setAddress(orgInfoBase.getAddress());
        pOrg.setLegalPersonality(orgInfoBase.getLegalPersonality());
        pOrg.setOrgName(orgInfoBase.getOrgName());
        pOrg.setOrgNo(orgInfoBase.getOrgNo());
        pOrg.setState("1".equalsIgnoreCase(orgInfoBase.getState()) ? "1" : "0");
        pOrg.setSuperOrgNo(StringUtil.nvl((String)orgInfoBase.getParentNo(), null));
        pOrg.setRemark(orgInfoBase.getRemark());
        pOrg.setOrgShortName(orgInfoBase.getOrgShortName());
        pOrg.setType(orgInfoBase.getType());
        if (orgInfoBase.getTags() != null && orgInfoBase.getTags().size() > 0) {
            pOrg.setTags(StringUtil.join((Iterable)orgInfoBase.getTags(), (String)","));
        }
        return pOrg;
    }

    private OrgInfoBase transform(POrg pOrg) {
        if (pOrg == null) {
            return null;
        }
        OrgInfoBase orgInfoBase = new OrgInfoBase();
        orgInfoBase.setAddress(pOrg.getAddress());
        orgInfoBase.setState("1".equalsIgnoreCase(pOrg.getState()) ? "1" : "0");
        orgInfoBase.setLegalPersonality(pOrg.getLegalPersonality());
        orgInfoBase.setOrgName(pOrg.getOrgName());
        orgInfoBase.setOrgNo(pOrg.getOrgNo());
        orgInfoBase.setParentNo(StringUtil.nvl((String)pOrg.getSuperOrgNo(), null));
        orgInfoBase.setRemark(pOrg.getRemark());
        orgInfoBase.setOrgShortName(pOrg.getOrgShortName());
        orgInfoBase.setType(pOrg.getType());
        if (StringUtil.isNotEmpty((String)pOrg.getTags())) {
            orgInfoBase.setTags(Arrays.asList(pOrg.getTags().split(",")));
        } else {
            orgInfoBase.setTags(new ArrayList());
        }
        return orgInfoBase;
    }

    private OrgNode transformNode(POrg pOrg) {
        return this.transformNode(pOrg, null);
    }

    private OrgNode transformNode(POrg pOrg, List<POrg> childrens) {
        if (pOrg == null) {
            return null;
        }
        OrgNode orgNode = new OrgNode();
        orgNode.setAddress(pOrg.getAddress());
        orgNode.setState("1".equalsIgnoreCase(pOrg.getState()) ? "1" : "0");
        orgNode.setLegalPersonality(pOrg.getLegalPersonality());
        orgNode.setOrgName(pOrg.getOrgName());
        orgNode.setOrgNo(pOrg.getOrgNo());
        orgNode.setParentNo(StringUtil.nvl((String)pOrg.getSuperOrgNo(), null));
        orgNode.setRemark(pOrg.getRemark());
        orgNode.setOrgShortName(pOrg.getOrgShortName());
        orgNode.setType(pOrg.getType());
        if (StringUtil.isNotEmpty((String)pOrg.getTags())) {
            orgNode.setTags(Arrays.asList(pOrg.getTags().split(",")));
        } else {
            orgNode.setTags(new ArrayList());
        }
        if (childrens != null) {
            ArrayList<OrgNode> clds = new ArrayList<OrgNode>();
            for (POrg o : childrens) {
                clds.add(this.transformNode(o, null));
            }
            orgNode.setChildren(clds);
        }
        return orgNode;
    }

    public HelpLocalOrgStorage getEditableLegalProxy(final String legal) {
        if (!this.legalable) {
            return this;
        }
        return new HelpLocalOrgStorage(true, this.pOrgMapper, this.pUserAffiliationMapper){

            @Override
            protected String getLegal() {
                return legal;
            }
        };
    }

    public HelpLocalOrgStorage getLegalProxy(String legal) {
        return this.getEditableLegalProxy(legal);
    }
}

