/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.StringUtil;
import com.help.dao.PLegalMapper;
import com.help.domain.LegalInfo;
import com.help.domain.PLegal;
import com.help.domain.PLegalExample;
import com.help.storage.ILegalStorage;
import com.help.storage.editable.IEditableLegalStorage;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class HelpLocalLegalStorage
implements IEditableLegalStorage {
    private PLegalMapper pLegalMapper;
    boolean legalable;

    protected String getLegal() {
        return null;
    }

    public HelpLocalLegalStorage(boolean legalable, PLegalMapper pLegalMapper) {
        this.legalable = legalable;
        this.pLegalMapper = pLegalMapper;
    }

    private boolean matchLegal(String legal) {
        if (!this.legalable) {
            return true;
        }
        String current = this.getLegal();
        return current == null || current.equalsIgnoreCase(legal);
    }

    public LegalInfo get(String legalNo) {
        if (this.matchLegal(legalNo)) {
            return this.transform(this.pLegalMapper.selectByPrimaryKey(legalNo));
        }
        return null;
    }

    public List<LegalInfo> list() {
        String legal = this.getLegal();
        PLegalExample example = new PLegalExample();
        if (this.legalable && StringUtil.isNotEmpty((String)legal)) {
            example.createCriteria().andLegalNameEqualTo(legal);
        }
        return this.pLegalMapper.selectByExample(example).stream().map(p -> this.transform((PLegal)p)).collect(Collectors.toList());
    }

    public UnifyPageData<LegalInfo> searchByPage(String name, UnifyPageInfo pageInfo) {
        PLegalExample example = null;
        String legal = this.getLegal();
        if (StringUtil.isNotEmpty((String)name)) {
            example = new PLegalExample();
            if (this.legalable && StringUtil.isNotEmpty((String)legal)) {
                example.createCriteria().andLegalNameLike("%" + name + "%").andLegalNoEqualTo(legal);
                example.or().andLegalNoLike("%" + name + "%").andLegalNoEqualTo(legal);
            } else {
                example.createCriteria().andLegalNameLike("%" + name + "%");
                example.or().andLegalNoLike("%" + name + "%");
            }
        } else if (this.legalable && StringUtil.isNotEmpty((String)legal)) {
            example = new PLegalExample();
            example.createCriteria().andLegalNoEqualTo(legal);
        }
        PageHelper.startPage((int)pageInfo.getPageIndex(), (int)pageInfo.getPageSize());
        List<PLegal> list = this.pLegalMapper.selectByExample(example);
        PageInfo info = new PageInfo(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData((Collection)info.getList().stream().map(p -> this.transform((PLegal)p)).collect(Collectors.toList()), pageInfo);
    }

    public void add(LegalInfo legalInfo) {
        if (this.legalable && StringUtil.isNotEmpty((String)this.getLegal())) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u60a8\u6ca1\u6709\u65b0\u589e\u6cd5\u4eba\u7684\u6743\u9650");
        }
        this.pLegalMapper.insert(this.transform(legalInfo));
    }

    public void edit(LegalInfo legalInfo) {
        if (!this.matchLegal(legalInfo.getLegalNo())) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u60a8\u6ca1\u6709\u4fee\u6539\u8be5\u6cd5\u4eba\u7684\u6743\u9650");
        }
        PLegal legal = this.transform(legalInfo);
        this.pLegalMapper.updateByPrimaryKey(legal);
    }

    public void delete(String legalNo) {
        if (this.legalable && StringUtil.isNotEmpty((String)this.getLegal())) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u60a8\u6ca1\u6709\u5220\u9664\u8be5\u6cd5\u4eba\u7684\u6743\u9650");
        }
        this.pLegalMapper.deleteByPrimaryKey(legalNo);
    }

    public void changeState(String legalNo, boolean enable) {
        if (!this.matchLegal(legalNo)) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u60a8\u6ca1\u6709\u4fee\u6539\u8be5\u6cd5\u4eba\u7684\u6743\u9650");
        }
        PLegal legal = new PLegal();
        legal.setLegalNo(legalNo);
        legal.setState(enable ? "1" : "0");
        this.pLegalMapper.updateColumnsByPrimaryKey(legal, "state");
    }

    private PLegal transform(LegalInfo legal) {
        if (legal == null) {
            return null;
        }
        PLegal info = new PLegal();
        info.setLegalName(legal.getLegalName());
        info.setLegalNo(legal.getLegalNo());
        info.setState("1".equalsIgnoreCase(legal.getState()) ? "1" : "0");
        return info;
    }

    private LegalInfo transform(PLegal legal) {
        if (legal == null) {
            return null;
        }
        LegalInfo info = new LegalInfo();
        info.setLegalName(legal.getLegalName());
        info.setLegalNo(legal.getLegalNo());
        info.setState("1".equalsIgnoreCase(legal.getState()) ? "1" : "0");
        return info;
    }

    public IEditableLegalStorage getEditableLegalProxy(final String legal) {
        if (!this.legalable) {
            return this;
        }
        return new HelpLocalLegalStorage(true, this.pLegalMapper){

            @Override
            protected String getLegal() {
                return legal;
            }
        };
    }

    public ILegalStorage getLegalProxy(String legal) {
        return this.getEditableLegalProxy(legal);
    }
}

