/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.StringUtil;
import com.help.dao.PDeptMapper;
import com.help.dao.PUserAffiliationMapper;
import com.help.domain.DeptInfo;
import com.help.domain.PDept;
import com.help.domain.PDeptExample;
import com.help.domain.PUserAffiliationExample;
import com.help.storage.editable.IEditableDeptStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

public class HelpLocalDeptStorage
implements IEditableDeptStorage {
    PDeptMapper pDeptMapper;
    PUserAffiliationMapper pUserAffiliationMapper;
    boolean legalable;

    public HelpLocalDeptStorage(boolean legalable, PDeptMapper pDeptMapper, PUserAffiliationMapper pUserAffiliationMapper) {
        this.pDeptMapper = pDeptMapper;
        this.pUserAffiliationMapper = pUserAffiliationMapper;
        this.legalable = legalable;
    }

    protected String getLegal() {
        return null;
    }

    private boolean matchLegal(String legal) {
        if (!this.legalable) {
            return true;
        }
        String current = this.getLegal();
        return current == null || current.equalsIgnoreCase(legal);
    }

    public void add(DeptInfo deptInfo) {
        if (!this.matchLegal(deptInfo.getLegalPersonality())) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u60a8\u53ea\u80fd\u65b0\u589e\u81ea\u8eab\u6cd5\u4eba\u4e0b\u7684\u90e8\u95e8\u4fe1\u606f");
        }
        this.pDeptMapper.insert(this.transform(deptInfo));
    }

    public void edit(DeptInfo deptInfo) {
        if (!this.matchLegal(deptInfo.getLegalPersonality())) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u60a8\u53ea\u80fd\u4fee\u6539\u81ea\u8eab\u6cd5\u4eba\u4e0b\u7684\u90e8\u95e8\u4fe1\u606f");
        }
        PDept dept = this.transform(deptInfo);
        this.pDeptMapper.updateByPrimaryKey(dept);
    }

    @Transactional
    public void delete(String deptNo) {
        DeptInfo dept = this.get(deptNo);
        if (dept == null) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u90e8\u95e8[" + deptNo + "]\u4e0d\u5b58\u5728");
        }
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andAffiliationNoEqualTo(deptNo).andTypeEqualTo("DEPT");
        this.pUserAffiliationMapper.deleteByExample(example);
        this.pDeptMapper.deleteByPrimaryKey(deptNo);
    }

    public void changeState(String deptNo, boolean enable) {
        DeptInfo old = this.get(deptNo);
        if (old == null) {
            throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD, "\u90e8\u95e8[" + deptNo + "]\u4e0d\u5b58\u5728");
        }
        PDept dept = new PDept();
        dept.setDeptNo(deptNo);
        dept.setState(enable ? "1" : "0");
        this.pDeptMapper.updateColumnsByPrimaryKey(dept, "state");
    }

    public HelpLocalDeptStorage getEditableLegalProxy(final String legal) {
        if (!this.legalable) {
            return this;
        }
        return new HelpLocalDeptStorage(true, this.pDeptMapper, this.pUserAffiliationMapper){

            @Override
            protected String getLegal() {
                return legal;
            }
        };
    }

    public DeptInfo get(String deptNo) {
        PDept dept = this.pDeptMapper.selectByPrimaryKey(deptNo);
        if (dept == null || !this.matchLegal(dept.getLegalPersonality())) {
            return null;
        }
        return this.transform(dept);
    }

    public List<DeptInfo> getAll(String ... deptNos) {
        if (deptNos != null && deptNos.length > 0) {
            String legal = this.getLegal();
            PDeptExample example = new PDeptExample();
            example.createCriteria().andDeptNoIn((List)Arrays.asList(deptNos)).andLegalPersonalityEqualToNotEmptyValue(legal);
            return this.pDeptMapper.selectByExample(example).stream().map(p -> this.transform((PDept)p)).collect(Collectors.toList());
        }
        return new ArrayList<DeptInfo>();
    }

    public List<DeptInfo> list() {
        PDeptExample example = new PDeptExample();
        example.createCriteria().andLegalPersonalityEqualToNotEmptyValue(this.getLegal());
        return this.pDeptMapper.selectByExample(example).stream().map(p -> this.transform((PDept)p)).collect(Collectors.toList());
    }

    public UnifyPageData<DeptInfo> searchByPage(String name, UnifyPageInfo pageInfo) {
        PDeptExample example = new PDeptExample();
        String legal = this.getLegal();
        if (StringUtil.isNotEmpty((String)name)) {
            example.createCriteria().andDeptNoLike("%" + name + "%").andLegalPersonalityEqualToNotEmptyValue(legal);
            example.or().andDeptNameLike("%" + name + "%").andLegalPersonalityEqualToNotEmptyValue(legal);
        } else {
            example.createCriteria().andLegalPersonalityEqualToNotEmptyValue(legal);
        }
        PageHelper.startPage((int)pageInfo.getPageIndex(), (int)pageInfo.getPageSize());
        List<PDept> list = this.pDeptMapper.selectByExample(example);
        PageInfo info = new PageInfo(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData((Collection)info.getList().stream().map(p -> this.transform((PDept)p)).collect(Collectors.toList()), pageInfo);
    }

    public HelpLocalDeptStorage getLegalProxy(String legal) {
        return this.getEditableLegalProxy(legal);
    }

    private PDept transform(DeptInfo deptInfo) {
        if (deptInfo == null) {
            return null;
        }
        PDept dept = new PDept();
        dept.setDeptNo(deptInfo.getDeptNo());
        dept.setRemark(deptInfo.getRemark());
        dept.setState("1".equalsIgnoreCase(deptInfo.getState()) ? "1" : "0");
        dept.setDeptName(deptInfo.getDeptName());
        dept.setLegalPersonality(deptInfo.getLegalPersonality());
        return dept;
    }

    private DeptInfo transform(PDept pDept) {
        if (pDept == null) {
            return null;
        }
        DeptInfo dept = new DeptInfo();
        dept.setDeptNo(pDept.getDeptNo());
        dept.setDeptName(pDept.getDeptName());
        dept.setState("1".equalsIgnoreCase(pDept.getState()) ? "1" : "0");
        dept.setRemark(pDept.getRemark());
        dept.setLegalPersonality(pDept.getLegalPersonality());
        return dept;
    }
}

