/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.util.StringUtil;
import com.help.dao.PRoleMapper;
import com.help.dao.PUserAffiliationMapper;
import com.help.domain.PRole;
import com.help.domain.PRoleExample;
import com.help.domain.PUserAffiliationExample;
import com.help.domain.RoleInfo;
import com.help.storage.editable.IEditableRoleStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

public class HelpLocalRoleStorage
implements IEditableRoleStorage {
    PRoleMapper pRoleMapper;
    PUserAffiliationMapper pUserAffiliationMapper;

    public HelpLocalRoleStorage(PRoleMapper pRoleMapper, PUserAffiliationMapper pUserAffiliationMapper) {
        this.pRoleMapper = pRoleMapper;
        this.pUserAffiliationMapper = pUserAffiliationMapper;
    }

    public void add(RoleInfo roleInfo) {
        this.pRoleMapper.insert(this.transform(roleInfo));
    }

    public void edit(RoleInfo roleInfo) {
        PRole role = this.transform(roleInfo);
        this.pRoleMapper.updateByPrimaryKey(role);
    }

    @Transactional
    public void delete(String roleNo) {
        PUserAffiliationExample example = new PUserAffiliationExample();
        example.createCriteria().andRoleNoEqualTo(roleNo);
        this.pUserAffiliationMapper.deleteByExample(example);
        this.pRoleMapper.deleteByPrimaryKey(roleNo);
    }

    public void changeState(String roleNo, boolean enable) {
        PRole role = new PRole();
        role.setRoleNo(roleNo);
        role.setState(enable ? "1" : "0");
        this.pRoleMapper.updateColumnsByPrimaryKey(role, "state");
    }

    public RoleInfo get(String roleNo) {
        return this.transform(this.pRoleMapper.selectByPrimaryKey(roleNo));
    }

    public List<RoleInfo> getAll(String ... roleNos) {
        if (roleNos != null && roleNos.length > 0) {
            PRoleExample example = new PRoleExample();
            example.createCriteria().andRoleNoIn((List)Arrays.asList(roleNos));
            return this.pRoleMapper.selectByExample(example).stream().map(p -> this.transform((PRole)p)).collect(Collectors.toList());
        }
        return new ArrayList<RoleInfo>();
    }

    public List<RoleInfo> list() {
        return this.pRoleMapper.selectByExample(null).stream().map(p -> this.transform((PRole)p)).collect(Collectors.toList());
    }

    public UnifyPageData<RoleInfo> searchByPage(String role, UnifyPageInfo pageInfo) {
        PRoleExample example = new PRoleExample();
        if (StringUtil.isNotEmpty((String)role)) {
            example.createCriteria().andRoleNoLike("%" + role + "%");
            example.or().andRoleNameLike("%" + role + "%");
        }
        PageHelper.startPage((int)pageInfo.getPageIndex(), (int)pageInfo.getPageSize());
        List<PRole> list = this.pRoleMapper.selectByExample(example);
        PageInfo info = new PageInfo(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData((Collection)info.getList().stream().map(p -> this.transform((PRole)p)).collect(Collectors.toList()), pageInfo);
    }

    private PRole transform(RoleInfo roleInfo) {
        if (roleInfo == null) {
            return null;
        }
        PRole role = new PRole();
        role.setRoleNo(roleInfo.getRoleNo());
        role.setRemark(roleInfo.getRemark());
        role.setState("1".equalsIgnoreCase(roleInfo.getState()) ? "1" : "0");
        role.setRoleName(roleInfo.getRoleName());
        return role;
    }

    private RoleInfo transform(PRole pRole) {
        if (pRole == null) {
            return null;
        }
        RoleInfo role = new RoleInfo();
        role.setRoleNo(pRole.getRoleNo());
        role.setRoleName(pRole.getRoleName());
        role.setState("1".equalsIgnoreCase(pRole.getState()) ? "1" : "0");
        role.setRemark(pRole.getRemark());
        return role;
    }
}

