/*
 * Decompiled with CFR 0.152.
 */
package com.help;

import com.help.HelpLocalLegalPersonAutoConfiguration;
import com.help.config.HelpManageConfig;
import com.help.dao.PUserAffiliationMapper;
import com.help.dao.PUserMapper;
import com.help.storage.HelpLocalUserAffiliationStorage;
import com.help.storage.HelpLocalUserStorage;
import com.help.storage.IUserAffiliationStorage;
import com.help.storage.IUserStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfigureBefore(value={HelpLocalLegalPersonAutoConfiguration.class})
public class HelpLocalUserAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpLocalUserAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={IUserStorage.class})
    public HelpLocalUserStorage iEditableUserStorage(@Autowired HelpManageConfig helpManageConfig, @Autowired PUserMapper pUserMapper, @Autowired PUserAffiliationMapper pUserAffiliationMapper) {
        HelpLocalUserStorage userService = new HelpLocalUserStorage(helpManageConfig.isMultiLegalEnable(), pUserMapper, pUserAffiliationMapper);
        this.logger.info("\u68c0\u6d4b\u5230[\u672c\u5730\u7528\u6237\u6a21\u5757],\u81ea\u52a8\u914d\u7f6e[HELP\u5e73\u53f0\u7528\u6237\u670d\u52a1]");
        return userService;
    }

    @Bean
    @ConditionalOnBean(value={IUserStorage.class})
    @ConditionalOnMissingBean(value={IUserAffiliationStorage.class})
    public HelpLocalUserAffiliationStorage iEditableUserAffiliationStorage(@Autowired HelpManageConfig helpManageConfig, @Autowired PUserMapper pUserMapper, @Autowired PUserAffiliationMapper pUserAffiliationMapper) {
        HelpLocalUserAffiliationStorage userService = new HelpLocalUserAffiliationStorage(helpManageConfig.isMultiLegalEnable(), pUserMapper, pUserAffiliationMapper);
        this.logger.info("\u68c0\u6d4b\u5230[HELP\u5e73\u53f0\u7528\u6237\u670d\u52a1],\u81ea\u52a8\u914d\u7f6e[HELP\u5e73\u53f0\u7528\u6237\u89d2\u8272\u5f52\u5c5e\u5173\u7cfb\u914d\u7f6e\u670d\u52a1]");
        return userService;
    }
}

