/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.help.domain.OrgInfoBase;
import com.help.domain.OrgNode;
import com.help.storage.HelpLocalOrgStorage;
import com.help.storage.IOrgStorage;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpIapOrgStorageProxy
implements IOrgStorage {
    Logger logger = LoggerFactory.getLogger(HelpIapOrgStorageProxy.class);
    HelpLocalOrgStorage helpLocalOrgStorage;

    public HelpIapOrgStorageProxy(HelpLocalOrgStorage helpLocalOrgStorage) {
        this.helpLocalOrgStorage = helpLocalOrgStorage;
    }

    public List<OrgInfoBase> listAll() {
        return this.helpLocalOrgStorage.listAll();
    }

    public List<OrgInfoBase> listByType(String type) {
        return this.helpLocalOrgStorage.listByType(type);
    }

    public OrgInfoBase get(String orgNo) {
        return this.helpLocalOrgStorage.get(orgNo);
    }

    public List<OrgInfoBase> getAll(String ... orgNos) {
        List list = this.helpLocalOrgStorage.getAll(orgNos);
        Arrays.stream(orgNos).forEach(r -> {
            if (!list.stream().anyMatch(p -> p.getOrgNo().equalsIgnoreCase((String)r))) {
                this.logger.warn("\u673a\u6784[{}]\u5728\u5458\u5de5\u7cfb\u7edf\u4e0d\u5b58\u5728\u6216\u672a\u540c\u6b65,\u5df2\u5ffd\u7565", r);
            }
        });
        return list;
    }

    public OrgNode getWithChilds(String orgNo) {
        return this.helpLocalOrgStorage.getWithChilds(orgNo);
    }

    public OrgNode getWithChilds(String orgNo, int level) {
        return this.helpLocalOrgStorage.getWithChilds(orgNo, level);
    }

    public OrgNode getWithAll(String orgNo) {
        return this.helpLocalOrgStorage.getWithAll(orgNo);
    }

    public List<OrgInfoBase> listTop() {
        return this.helpLocalOrgStorage.listTop();
    }

    public List<OrgNode> listTopWithChilds() {
        return this.helpLocalOrgStorage.listTopWithChilds();
    }

    public List<OrgNode> listTopWithAll() {
        return this.helpLocalOrgStorage.listTopWithAll();
    }

    public HelpIapOrgStorageProxy getLegalProxy(String legal) {
        return this;
    }
}

