/*
 * Decompiled with CFR 0.152.
 */
package com.help.schedule;

import com.help.common.HelpIapHttpClient;
import com.help.common.HelpIapMessageBuilder;
import com.help.common.ICacheable;
import com.help.common.concurrent.IHelpLocker;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.Convert;
import com.help.common.util.Security;
import com.help.common.util.StringUtil;
import com.help.config.HelpEmployeeCenterConfig;
import com.help.constant.EmployeeType;
import com.help.constraint.IHelpSystemComponent;
import com.help.crcb.hub.CrcbHubRequestInfo;
import com.help.dao.PParamMapper;
import com.help.dao.PUserMapper;
import com.help.dao.batch.BatchHelper;
import com.help.domain.PParam;
import com.help.domain.PUser;
import com.help.filter.IUserSyncFilter;
import com.help.iap.HelpIapRequestInfo;
import com.help.iap.HelpIapResponseInfo;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;

public class HelpIapUserSyncSchedule
implements IHelpSystemComponent,
ICacheable {
    Logger logger = LoggerFactory.getLogger(HelpIapUserSyncSchedule.class);
    @Autowired
    PUserMapper pUserMapper;
    @Autowired
    PParamMapper pParamMapper;
    @Autowired
    IHelpLocker iHelpLocker;
    @Value(value="${spring.application.name}")
    String appName;
    @Autowired
    HelpEmployeeCenterConfig helpEmployeeCenterConfig;
    @Autowired(required=false)
    CacheManager cacheManager;
    @Autowired(required=false)
    IUserSyncFilter iUserSyncFilter;
    @Autowired
    HelpIapHttpClient helpIapHttpClient;
    @Autowired
    HelpIapMessageBuilder helpIapMessageBuilder;
    @Value(value="#{helpEmployeeCenterConfig.corn}")
    private String corn;
    @Autowired
    BatchHelper batchHelper;

    @Scheduled(cron="#{helpEmployeeCenterConfig.corn}")
    public void sync() {
        this.sync(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public void sync(boolean ignoreTime) {
        this.logger.debug("\u6b63\u5728\u5c1d\u8bd5\u540c\u6b65\u5458\u5de5\u4e2d\u5fc3\u7528\u6237\u6570\u636e");
        boolean haveLock = false;
        try {
            haveLock = this.iHelpLocker.tryLock(this.appName + "-ISP-USER-SYNC-LOCK", (long)(this.helpEmployeeCenterConfig.getLockWait() * 1000), (long)(this.helpEmployeeCenterConfig.getLockLease() * 1000));
            if (haveLock) {
                long startTime = System.currentTimeMillis();
                PParam last = this.pParamMapper.selectByPrimaryKey("LAST_SYNC_USER");
                if (last != null) {
                    String time = last.getParamValue();
                    if (!ignoreTime && StringUtil.isNotEmpty((String)time) && System.currentTimeMillis() - Convert.toDate((String)time, (String)"yyyy-MM-dd HH:mm:ss").getTime() < (long)(this.helpEmployeeCenterConfig.getMinSyncSpan() * 60 * 1000)) {
                        return;
                    }
                }
                this.logger.info("\u5f00\u59cb\u6267\u884c[\u5458\u5de5\u7cfb\u7edf\u7528\u6237\u6570\u636e\u540c\u6b65\u670d\u52a1]");
                HelpIapRequestInfo request = this.helpIapMessageBuilder.buildRequest();
                HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/getUser", (CrcbHubRequestInfo)request);
                if (this.iUserSyncFilter == null) {
                    this.iUserSyncFilter = new IUserSyncFilter(){

                        @Override
                        public void afterSync(List<Map> users) {
                        }

                        @Override
                        public boolean test(Map map) {
                            return true;
                        }
                    };
                }
                List<EmployeeType> types = Arrays.asList(this.helpEmployeeCenterConfig.getIapUserFilter());
                List<Map> users = ((List)result.get((Object)"pageInfoList")).stream().filter(p -> types.contains(this.parseType((Map<String, Object>)p))).filter(this.iUserSyncFilter).collect(Collectors.toList());
                long mycount = this.pUserMapper.countByExample(null);
                if (mycount - (long)users.size() > (long)this.helpEmployeeCenterConfig.getThreshold()) {
                    throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u5458\u5de5\u7cfb\u7edf\u7528\u6237\u6570\u91cf\u4e0e\u672c\u5730\u5dee\u5f02\u8fc7\u5927(\u672c\u5730\u6570\u636e[" + mycount + "]\u6761,\u5458\u5de5\u7cfb\u7edf\u6570\u636e[" + users.size() + "]\u6761),\u5df2\u4e2d\u6b62\u81ea\u52a8\u540c\u6b65\u4efb\u52a1");
                }
                this.pUserMapper.deleteByExample(null);
                this.batchHelper.getBatchExecuter(PUserMapper.class).execute(users, (dao, u) -> {
                    PUser user = new PUser();
                    user.setUserNo(Convert.toString(u.get("partyId")));
                    user.setUserName(Convert.toString(u.get("lastName")));
                    if (StringUtil.isNotEmpty(u.get("createdStamp"))) {
                        user.setCreateTime(Convert.toDate((String)Convert.toString(u.get("createdStamp")), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    user.setOrgNo(Convert.toString(u.get("organization")));
                    user.setDeptNo(Convert.toString(u.get("department")));
                    user.setState("1");
                    if (StringUtil.isNotEmpty(u.get("workPhone")) && Convert.toString(u.get("workPhone")).length() == 11) {
                        user.setPhone(Convert.toString(u.get("workPhone")));
                    }
                    user.setCertCode(Convert.toString(u.get("cardId")));
                    user.setType(this.parseType((Map<String, Object>)u).name());
                    String personType = Convert.toString(u.get("personType"));
                    if ("200".equalsIgnoreCase(personType)) {
                        user.setRemark("\u5ba2\u670d\u4eba\u5458(\u5ba2\u670d\u7cfb\u7edf)");
                    }
                    user.setJobNumber(Convert.toString(u.get("partyId")));
                    user.setPassword(Security.toSHA256((String)"000000"));
                    dao.insert(user);
                });
                this.iUserSyncFilter.afterSync(users);
                if (last != null) {
                    last.setParamValue(Convert.toString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    last.setRemark("\u5458\u5de5\u6570\u636e\u4e0a\u6b21\u540c\u6b65(" + users.size() + "\u6761)");
                    this.pParamMapper.updateByPrimaryKey(last);
                } else {
                    last = new PParam();
                    last.setParamKey("LAST_SYNC_USER");
                    last.setParamValue(Convert.toString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    last.setRemark("\u5458\u5de5\u6570\u636e\u4e0a\u6b21\u540c\u6b65(" + users.size() + "\u6761)");
                    this.pParamMapper.insert(last);
                }
                this.logger.info("[\u5458\u5de5\u7cfb\u7edf\u7528\u6237\u6570\u636e\u540c\u6b65\u670d\u52a1]\u6267\u884c\u6210\u529f,\u540c\u6b65\u7528\u6237\u6570\u91cf[{}],\u603b\u5171\u8017\u65f6[{}ms]", (Object)users.size(), (Object)(System.currentTimeMillis() - startTime));
                if (this.cacheManager != null) {
                    this.cacheManager.getCache("dictionary").clear();
                }
            } else {
                this.logger.info("[\u5458\u5de5\u7cfb\u7edf\u7528\u6237\u6570\u636e\u540c\u6b65\u670d\u52a1]\u68c0\u6d4b\u5230\u5df2\u5728\u8fd0\u884c,\u5df2\u4e2d\u6b62\u540c\u6b65");
            }
        }
        catch (InterruptedException e) {
            this.logger.info("[\u5458\u5de5\u7cfb\u7edf\u7528\u6237\u6570\u636e\u540c\u6b65\u670d\u52a1]\u83b7\u53d6\u9501\u5931\u8d25,\u68c0\u6d4b\u5230\u7ebf\u7a0b\u88ab\u6253\u65ad", (Throwable)e);
        }
        finally {
            if (haveLock) {
                this.iHelpLocker.unlock(this.appName + "-ISP-USER-SYNC-LOCK");
            }
        }
        this.logger.debug("\u5458\u5de5\u4e2d\u5fc3\u7528\u6237\u540c\u6b65\u670d\u52a1\u9000\u51fa");
    }

    private EmployeeType parseType(Map<String, Object> u) {
        String personType = Convert.toString((Object)u.get("personType"));
        if (StringUtil.isNotEmpty((String)personType)) {
            if (personType.length() < 3) {
                return EmployeeType.REGULAR;
            }
            if (personType.startsWith("1")) {
                return EmployeeType.REGULAR;
            }
            if (personType.startsWith("2")) {
                return EmployeeType.EPIBOLY;
            }
            if (personType.startsWith("3")) {
                return EmployeeType.TEMPORARY;
            }
            return EmployeeType.EPIBOLY;
        }
        return EmployeeType.EPIBOLY;
    }

    public String getName() {
        return "\u5458\u5de5\u7cfb\u7edf\u7528\u6237\u540c\u6b65\u670d\u52a1[" + this.corn + "]";
    }

    public void refresh() {
        this.sync(true);
    }
}

