/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.help.common.HelpIapHttpClient;
import com.help.common.HelpIapMessageBuilder;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.crcb.hub.CrcbHubRequestInfo;
import com.help.domain.UserInfo;
import com.help.iap.HelpIapRequestInfo;
import com.help.iap.HelpIapResponseInfo;
import com.help.storage.HelpLocalUserStorage;
import com.help.storage.IUserStorage;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HelpIapUserStorageProxy
implements IUserStorage {
    Logger logger = LoggerFactory.getLogger(HelpIapUserStorageProxy.class);
    private HelpLocalUserStorage helpLocalUserStorage;
    @Autowired
    HelpIapHttpClient helpIapHttpClient;
    @Autowired
    HelpIapMessageBuilder helpIapMessageBuilder;

    public HelpIapUserStorageProxy(HelpLocalUserStorage helpLocalUserStorage) {
        this.helpLocalUserStorage = helpLocalUserStorage;
    }

    public UserInfo get(String userNo) {
        return this.helpLocalUserStorage.get(userNo);
    }

    public List<UserInfo> getAll(String ... userNos) {
        List list = this.helpLocalUserStorage.getAll(userNos);
        Arrays.stream(userNos).forEach(r -> {
            if (!list.stream().anyMatch(p -> p.getUserNo().equalsIgnoreCase((String)r))) {
                this.logger.warn("\u5458\u5de5[{}]\u5728\u5458\u5de5\u7cfb\u7edf\u4e0d\u5b58\u5728\u6216\u672a\u540c\u6b65,\u5df2\u5ffd\u7565", r);
            }
        });
        return list;
    }

    public UserInfo get(String userNo, String password) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("userNo", (Object)userNo);
        param.put("password", (Object)password);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/userInfo", (CrcbHubRequestInfo)param);
        List users = (List)result.get((Object)"pageInfoList");
        if (users == null || users.size() == 0) {
            return null;
        }
        return this.get(userNo);
    }

    public UserInfo getByJobNumber(String jobNumber) {
        return this.helpLocalUserStorage.getByJobNumber(jobNumber);
    }

    public UserInfo getByPhone(String phone) {
        return this.helpLocalUserStorage.getByPhone(phone);
    }

    public List<UserInfo> list() {
        return this.helpLocalUserStorage.list();
    }

    public UnifyPageData<UserInfo> listByPage(UnifyPageInfo pageInfo) {
        return this.helpLocalUserStorage.listByPage(pageInfo);
    }

    public UnifyPageData<UserInfo> searchByPage(String user, String orgNo, String deptNo, UnifyPageInfo pageInfo) {
        return this.helpLocalUserStorage.searchByPage(user, orgNo, deptNo, pageInfo);
    }

    public HelpIapUserStorageProxy getLegalProxy(String legal) {
        return this;
    }
}

