/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.help.common.HelpIapHttpClient;
import com.help.common.HelpIapMessageBuilder;
import com.help.common.util.BeanConvert;
import com.help.common.util.Convert;
import com.help.config.HelpCrcbIapConfig;
import com.help.crcb.hub.CrcbHubRequestInfo;
import com.help.domain.UserAffiliationInfo;
import com.help.iap.HelpIapRequestInfo;
import com.help.iap.HelpIapResponseInfo;
import com.help.storage.editable.IEditableUserAffiliationStorage;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HelpIapUserAffiliationStorage
implements IEditableUserAffiliationStorage {
    Logger logger = LoggerFactory.getLogger(HelpIapUserAffiliationStorage.class);
    @Autowired
    HelpCrcbIapConfig helpCrcbIapConfig;
    @Autowired
    HelpIapHttpClient helpIapHttpClient;
    @Autowired
    HelpIapMessageBuilder helpIapMessageBuilder;

    public void addUserToRole(String userNo, String roleNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("userNo", (Object)userNo);
        param.put("roleNo", (Object)roleNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/addUserToRole", (CrcbHubRequestInfo)param);
    }

    public void addUserToOrgRole(String userNo, String orgNo, String roleNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("userNo", (Object)userNo);
        param.put("roleNo", (Object)roleNo);
        param.put("orgNo", (Object)orgNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/addUserToOrgRole", (CrcbHubRequestInfo)param);
    }

    public void addUserToDeptRole(String userNo, String deptNo, String roleNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("userNo", (Object)userNo);
        param.put("roleNo", (Object)roleNo);
        param.put("deptNo", (Object)deptNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/addUserToDeptRole", (CrcbHubRequestInfo)param);
    }

    public void removeUserFromRole(String userNo, String roleNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("userNo", (Object)userNo);
        param.put("roleNo", (Object)roleNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/removeUserFromRole", (CrcbHubRequestInfo)param);
    }

    public void removeUserFromOrgRole(String userNo, String orgNo, String roleNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("userNo", (Object)userNo);
        param.put("roleNo", (Object)roleNo);
        param.put("orgNo", (Object)orgNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/removeUserFromOrgRole", (CrcbHubRequestInfo)param);
    }

    public void removeUserFromDeptRole(String userNo, String deptNo, String roleNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("userNo", (Object)userNo);
        param.put("roleNo", (Object)roleNo);
        param.put("deptNo", (Object)deptNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/removeUserFromDeptRole", (CrcbHubRequestInfo)param);
    }

    public void removeAllUsersByOrg(String orgNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("orgNo", (Object)orgNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/removeAllUsersByOrg", (CrcbHubRequestInfo)param);
    }

    public void removeAllUsersByDept(String deptNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("deptNo", (Object)deptNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/removeAllUsersByDept", (CrcbHubRequestInfo)param);
    }

    public void removeAllUsersByRole(String roleNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("roleNo", (Object)roleNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/removeAllUsersByRole", (CrcbHubRequestInfo)param);
    }

    public List<String> listRoleByUser(String userNo) {
        return this.listRoleAffiliationByUser(userNo).stream().map(p -> p.getRoleNo()).distinct().collect(Collectors.toList());
    }

    public List<String> listRoleByUserAndOrg(String userNo, String orgNo) {
        return this.listRoleAffiliationByUser(userNo).stream().filter(p -> "ORG".equalsIgnoreCase(p.getAffiType()) && orgNo.equalsIgnoreCase(p.getAffiNo())).map(p -> p.getRoleNo()).distinct().collect(Collectors.toList());
    }

    public List<String> listRoleByUserAndDept(String userNo, String deptNo) {
        return this.listRoleAffiliationByUser(userNo).stream().filter(p -> "DEPT".equalsIgnoreCase(p.getAffiType()) && deptNo.equalsIgnoreCase(p.getAffiNo())).map(p -> p.getRoleNo()).distinct().collect(Collectors.toList());
    }

    public List<UserAffiliationInfo> listRoleAffiliationByUser(String userNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("userNo", (Object)userNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/listRoleByUser", (CrcbHubRequestInfo)param);
        List roles = (List)result.get((Object)"pageInfoList");
        return roles.stream().map(p -> {
            UserAffiliationInfo info = new UserAffiliationInfo();
            info.setUserNo(Convert.toString(p.get("userLoginId")));
            info.setRoleNo(Convert.toString(p.get("groupId")));
            String partyType = Convert.toString(p.get("partyType"));
            if ("NONE".equalsIgnoreCase(partyType) || "000000".equalsIgnoreCase(Convert.toString(p.get("partyId")))) {
                info.setAffiType("");
            } else if ("DEPARTMENT".equalsIgnoreCase(partyType)) {
                info.setAffiType("DEPT");
                info.setAffiNo(Convert.toString(p.get("partyId")));
            } else if ("ORGANIZATION".equalsIgnoreCase(partyType)) {
                info.setAffiType("ORG");
                info.setAffiNo(Convert.toString(p.get("partyId")));
            } else {
                this.logger.warn("[\u5458\u5de5\u4e2d\u5fc3\u89d2\u8272\u6a21\u5757]\u67e5\u8be2\u5230\u4e00\u6761\u65e0\u6548\u7684\u89d2\u8272\u5f52\u5c5e\u8bb0\u5f55,[{}]\u5df2\u5ffd\u7565", (Object)BeanConvert.toJson((Object)p));
                return null;
            }
            return info;
        }).filter(p -> p != null).collect(Collectors.toList());
    }

    public List<String> listUserNoByOrgAndRole(String org, String role) {
        return this.listRoleAffiliationByRole(role).stream().filter(p -> "ORG".equalsIgnoreCase(p.getAffiType()) && org.equalsIgnoreCase(p.getAffiNo())).map(p -> p.getUserNo()).distinct().collect(Collectors.toList());
    }

    public List<String> listUserNoByDeptAndRole(String dept, String role) {
        return this.listRoleAffiliationByRole(role).stream().filter(p -> "DEPT".equalsIgnoreCase(p.getAffiType()) && dept.equalsIgnoreCase(p.getAffiNo())).map(p -> p.getUserNo()).distinct().collect(Collectors.toList());
    }

    public List<UserAffiliationInfo> listRoleAffiliationByOrg(String orgNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("orgNo", (Object)orgNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/listRoleByOrg", (CrcbHubRequestInfo)param);
        List roles = (List)result.get((Object)"pageInfoList");
        return roles.stream().map(p -> {
            UserAffiliationInfo info = new UserAffiliationInfo();
            info.setUserNo(Convert.toString(p.get("userLoginId")));
            info.setRoleNo(Convert.toString(p.get("groupId")));
            String partyType = Convert.toString(p.get("partyType"));
            if (!"ORGANIZATION".equalsIgnoreCase(partyType)) {
                this.logger.warn("[\u5458\u5de5\u4e2d\u5fc3\u89d2\u8272\u6a21\u5757]\u67e5\u8be2\u5230\u4e00\u6761\u65e0\u6548\u7684\u673a\u6784\u89d2\u8272\u5f52\u5c5e\u8bb0\u5f55,[{}]\u5df2\u5ffd\u7565", (Object)BeanConvert.toJson((Object)p));
                return null;
            }
            info.setAffiType("ORG");
            info.setAffiNo(Convert.toString(p.get("partyId")));
            return info;
        }).filter(p -> p != null).collect(Collectors.toList());
    }

    public List<UserAffiliationInfo> listRoleAffiliationByDept(String deptNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("deptNo", (Object)deptNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/listRoleByDept", (CrcbHubRequestInfo)param);
        List roles = (List)result.get((Object)"pageInfoList");
        return roles.stream().map(p -> {
            UserAffiliationInfo info = new UserAffiliationInfo();
            info.setUserNo(Convert.toString(p.get("userLoginId")));
            info.setRoleNo(Convert.toString(p.get("groupId")));
            String partyType = Convert.toString(p.get("partyType"));
            if (!"DEPARTMENT".equalsIgnoreCase(partyType)) {
                this.logger.warn("[\u5458\u5de5\u4e2d\u5fc3\u89d2\u8272\u6a21\u5757]\u67e5\u8be2\u5230\u4e00\u6761\u65e0\u6548\u7684\u90e8\u95e8\u89d2\u8272\u5f52\u5c5e\u8bb0\u5f55,[{}]\u5df2\u5ffd\u7565", (Object)BeanConvert.toJson((Object)p));
                return null;
            }
            info.setAffiType("DEPT");
            info.setAffiNo(Convert.toString(p.get("partyId")));
            return info;
        }).filter(p -> p != null).collect(Collectors.toList());
    }

    public List<UserAffiliationInfo> listRoleAffiliationByRole(String roleNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        param.put("roleNo", (Object)roleNo);
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/listRoleByRole", (CrcbHubRequestInfo)param);
        List roles = (List)result.get((Object)"pageInfoList");
        return roles.stream().map(p -> {
            UserAffiliationInfo info = new UserAffiliationInfo();
            info.setUserNo(Convert.toString(p.get("userLoginId")));
            info.setRoleNo(Convert.toString(p.get("groupId")));
            String partyType = Convert.toString(p.get("partyType"));
            if ("NONE".equalsIgnoreCase(partyType) || "000000".equalsIgnoreCase(Convert.toString(p.get("partyId")))) {
                info.setAffiType("");
            } else if ("DEPARTMENT".equalsIgnoreCase(partyType)) {
                info.setAffiType("DEPT");
                info.setAffiNo(Convert.toString(p.get("partyId")));
            } else if ("ORGANIZATION".equalsIgnoreCase(partyType)) {
                info.setAffiType("ORG");
                info.setAffiNo(Convert.toString(p.get("partyId")));
            } else {
                this.logger.warn("[\u5458\u5de5\u4e2d\u5fc3\u89d2\u8272\u6a21\u5757]\u67e5\u8be2\u5230\u4e00\u6761\u65e0\u6548\u7684\u89d2\u8272\u5f52\u5c5e\u8bb0\u5f55,[{}]\u5df2\u5ffd\u7565", (Object)BeanConvert.toJson((Object)p));
                return null;
            }
            return info;
        }).filter(p -> p != null).collect(Collectors.toList());
    }

    public HelpIapUserAffiliationStorage getEditableLegalProxy(String legal) {
        return this;
    }

    public HelpIapUserAffiliationStorage getLegalProxy(String legal) {
        return this;
    }
}

